/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate.impl;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.translate.impl.AbstractTranslator;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTGTranslator
extends AbstractTranslator {
    public static final String RTG_TRANSLATE_URL_BASE = "http://localhost:6060";
    public static final String RTG_PROPS = "translator.rtg.properties";
    private static final Logger LOG = LoggerFactory.getLogger(RTGTranslator.class);
    private WebClient client;
    private boolean isAvailable = false;

    public RTGTranslator() {
        String rtgBaseUrl = RTG_TRANSLATE_URL_BASE;
        Properties config = new Properties();
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(RTG_PROPS);){
            if (stream != null) {
                config.load(stream);
            }
            rtgBaseUrl = config.getProperty("rtg.base.url", rtgBaseUrl);
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        LOG.info("RTG base URL: " + rtgBaseUrl);
        ArrayList<JacksonJsonProvider> providers = new ArrayList<JacksonJsonProvider>();
        providers.add(new JacksonJsonProvider());
        try {
            this.client = WebClient.create((String)rtgBaseUrl, providers);
            this.isAvailable = this.client.head().getStatus() == 200;
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            this.isAvailable = false;
        }
    }

    public String translate(String text, String sourceLanguage, String targetLanguage) throws TikaException, IOException {
        return this.translate(text);
    }

    public String translate(String text, String targetLanguage) throws TikaException, IOException {
        return this.translate(text);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String translate(String text) throws TikaException, IOException {
        if (!this.isAvailable) {
            return text;
        }
        HashMap<String, List<String>> input = new HashMap<String, List<String>>();
        input.put("source", Arrays.asList(text.split("(?<=(?<![A-Z])\\. )|\\n")));
        Response response = this.client.path((Object)"translate").type("application/json").accept(new String[]{"application/json"}).post(input);
        try (InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), Charset.defaultCharset());){
            JSONParser parser = new JSONParser();
            JSONObject obj = (JSONObject)parser.parse((Reader)reader);
            List sentences = (List)obj.get((Object)"translation");
            String string = String.join((CharSequence)"\n", sentences);
            return string;
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }
}

