/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.translate.Translator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YandexTranslator
implements Translator {
    private static final Logger LOG = LoggerFactory.getLogger(YandexTranslator.class);
    private static final String YANDEX_TRANSLATE_URL_BASE = "https://translate.yandex.net/api/v1.5/tr.json/translate";
    private static final String DEFAULT_KEY = "dummy-key";
    private String apiKey;
    private String format = "plain";

    public YandexTranslator() {
        Properties config = new Properties();
        try {
            config.load(YandexTranslator.class.getResourceAsStream("translator.yandex.properties"));
            this.apiKey = config.getProperty("translator.api-key");
            this.format = config.getProperty("translator.text.format");
        }
        catch (Exception e) {
            LOG.warn("Exception loading Yandex config", (Throwable)e);
        }
    }

    public String translate(String text, String sourceLanguage, String targetLanguage) throws TikaException, IOException {
        if (!this.isAvailable()) {
            return text;
        }
        WebClient client = WebClient.create((String)YANDEX_TRANSLATE_URL_BASE);
        String langCode = sourceLanguage == null ? targetLanguage : sourceLanguage + '-' + targetLanguage;
        Response response = client.accept(new String[]{"application/json"}).query("key", new Object[]{this.apiKey}).query("lang", new Object[]{langCode}).query("text", new Object[]{text}).get();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        String line = null;
        StringBuffer responseText = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            responseText.append(line);
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonResp = mapper.readTree(responseText.toString());
            if (!jsonResp.findValuesAsText("code").isEmpty()) {
                String code = (String)jsonResp.findValuesAsText("code").get(0);
                if (code.equals("200")) {
                    return jsonResp.findValue("text").get(0).asText();
                }
                throw new TikaException(jsonResp.findValue("message").get(0).asText());
            }
            throw new TikaException("Return message not recognized: " + responseText.toString().substring(0, Math.min(responseText.length(), 100)));
        }
        catch (JsonParseException e) {
            throw new TikaException("Error requesting translation from '" + sourceLanguage + "' to '" + targetLanguage + "', JSON response from Lingo24 is not well formatted: " + responseText.toString());
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String translate(String text, String targetLanguage) throws TikaException, IOException {
        return this.translate(text, null, targetLanguage);
    }

    public boolean isAvailable() {
        return this.apiKey != null && !this.apiKey.equals(DEFAULT_KEY);
    }
}

