/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.xmp.convert;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.microsoft.rtf.RTFParser;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.apache.tika.xmp.convert.GenericConverter;
import org.apache.tika.xmp.convert.ITikaToXMPConverter;
import org.apache.tika.xmp.convert.MSOfficeBinaryConverter;
import org.apache.tika.xmp.convert.MSOfficeXMLConverter;
import org.apache.tika.xmp.convert.OpenDocumentConverter;
import org.apache.tika.xmp.convert.RTFConverter;

public class TikaToXMP {
    private static Map<MediaType, Class<? extends ITikaToXMPConverter>> converterMap;

    public static XMPMeta convert(Metadata tikaMetadata) throws TikaException {
        if (tikaMetadata == null) {
            throw new IllegalArgumentException("Metadata parameter must not be null");
        }
        String mimetype = tikaMetadata.get("Content-Type");
        if (mimetype == null) {
            mimetype = tikaMetadata.get(TikaCoreProperties.FORMAT);
        }
        return TikaToXMP.convert(tikaMetadata, mimetype);
    }

    public static XMPMeta convert(Metadata tikaMetadata, String mimetype) throws TikaException {
        if (tikaMetadata == null) {
            throw new IllegalArgumentException("Metadata parameter must not be null");
        }
        ITikaToXMPConverter converter = null;
        converter = TikaToXMP.isConverterAvailable(mimetype) ? TikaToXMP.getConverter(mimetype) : new GenericConverter();
        XMPMeta xmp = null;
        if (converter != null) {
            try {
                xmp = converter.process(tikaMetadata);
            }
            catch (XMPException e) {
                throw new TikaException("Tika metadata could not be converted to XMP", (Throwable)e);
            }
        } else {
            xmp = XMPMetaFactory.create();
        }
        return xmp;
    }

    public static boolean isConverterAvailable(String mimetype) {
        MediaType type = MediaType.parse((String)mimetype);
        if (type != null) {
            return TikaToXMP.getConverterMap().get(type) != null;
        }
        return false;
    }

    public static ITikaToXMPConverter getConverter(String mimetype) throws TikaException {
        Class<? extends ITikaToXMPConverter> clazz;
        if (mimetype == null) {
            throw new IllegalArgumentException("mimetype must not be null");
        }
        ITikaToXMPConverter converter = null;
        MediaType type = MediaType.parse((String)mimetype);
        if (type != null && (clazz = TikaToXMP.getConverterMap().get(type)) != null) {
            try {
                converter = clazz.newInstance();
            }
            catch (Exception e) {
                throw new TikaException("TikaToXMP converter class cannot be instantiated for mimetype: " + type.toString(), (Throwable)e);
            }
        }
        return converter;
    }

    private static Map<MediaType, Class<? extends ITikaToXMPConverter>> getConverterMap() {
        if (converterMap == null) {
            converterMap = new HashMap<MediaType, Class<? extends ITikaToXMPConverter>>();
            TikaToXMP.initialize();
        }
        return converterMap;
    }

    private static void initialize() {
        ParseContext parseContext = new ParseContext();
        TikaToXMP.addConverter(new OfficeParser().getSupportedTypes(parseContext), MSOfficeBinaryConverter.class);
        TikaToXMP.addConverter(new RTFParser().getSupportedTypes(parseContext), RTFConverter.class);
        TikaToXMP.addConverter(new OOXMLParser().getSupportedTypes(parseContext), MSOfficeXMLConverter.class);
        TikaToXMP.addConverter(new OpenDocumentParser().getSupportedTypes(parseContext), OpenDocumentConverter.class);
    }

    private static void addConverter(Set<MediaType> supportedTypes, Class<? extends ITikaToXMPConverter> converter) {
        for (MediaType type : supportedTypes) {
            TikaToXMP.getConverterMap().put(type, converter);
        }
    }
}

