/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.xmp.convert;

import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.XMPSchemaRegistry;
import com.adobe.internal.xmp.XMPUtils;
import com.adobe.internal.xmp.options.PropertyOptions;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.xmp.convert.ITikaToXMPConverter;
import org.apache.tika.xmp.convert.Namespace;

public abstract class AbstractConverter
implements ITikaToXMPConverter {
    private Metadata metadata;
    protected XMPMeta meta = XMPMetaFactory.create();

    @Override
    public abstract XMPMeta process(Metadata var1) throws XMPException;

    protected abstract Set<Namespace> getAdditionalNamespaces();

    public AbstractConverter() throws TikaException {
        this.metadata = new Metadata();
        this.registerNamespaces(this.getAdditionalNamespaces());
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public XMPMeta getXMPMeta() {
        return this.meta;
    }

    protected void registerNamespaces(Set<Namespace> namespaces) throws TikaException {
        XMPSchemaRegistry registry = XMPMetaFactory.getSchemaRegistry();
        for (Namespace namespace : namespaces) {
            try {
                registry.registerNamespace(namespace.uri, namespace.prefix);
            }
            catch (XMPException e) {
                throw new TikaException("Namespace needed by converter could not be registiered with XMPCore", (Throwable)e);
            }
        }
    }

    protected void createProperty(Property metadataProperty, String ns, String propertyName) throws XMPException {
        this.createProperty(metadataProperty.getName(), ns, propertyName);
    }

    protected void createProperty(String tikaKey, String ns, String propertyName) throws XMPException {
        String value = this.metadata.get(tikaKey);
        if (value != null && value.length() > 0) {
            this.meta.setProperty(ns, propertyName, (Object)value);
        }
    }

    protected void createLangAltProperty(Property metadataProperty, String ns, String propertyName) throws XMPException {
        this.createLangAltProperty(metadataProperty.getName(), ns, propertyName);
    }

    protected void createLangAltProperty(String tikaKey, String ns, String propertyName) throws XMPException {
        String value = this.metadata.get(tikaKey);
        if (value != null && value.length() > 0) {
            this.meta.setLocalizedText(ns, propertyName, null, "x-default", value);
        }
    }

    protected void createArrayProperty(Property metadataProperty, String nsDc, String arrayProperty, int arrayType) throws XMPException {
        this.createArrayProperty(metadataProperty.getName(), nsDc, arrayProperty, arrayType);
    }

    protected void createArrayProperty(String tikaKey, String ns, String propertyName, int arrayType) throws XMPException {
        String[] values = this.metadata.getValues(tikaKey);
        if (values != null) {
            this.meta.setProperty(ns, propertyName, null, new PropertyOptions(arrayType));
            for (String value : values) {
                this.meta.appendArrayItem(ns, propertyName, value);
            }
        }
    }

    protected void createCommaSeparatedArray(Property metadataProperty, String nsDc, String arrayProperty, int arrayType) throws XMPException {
        this.createCommaSeparatedArray(metadataProperty.getName(), nsDc, arrayProperty, arrayType);
    }

    protected void createCommaSeparatedArray(String tikaKey, String ns, String propertyName, int arrayType) throws XMPException {
        String value = this.metadata.get(tikaKey);
        if (value != null && value.length() > 0) {
            XMPUtils.separateArrayItems((XMPMeta)this.meta, (String)ns, (String)propertyName, (String)value, (PropertyOptions)new PropertyOptions(arrayType), (boolean)false);
        }
    }
}

