/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
implements Serializable {
    protected Set<String> roles = null;
    protected Object value = null;
    private String renderer = null;
    @Deprecated
    private String name = null;

    public Attribute() {
    }

    public Attribute(Object value) {
        this.value = value;
    }

    public Attribute(Attribute attribute) {
        this.name = attribute.name;
        this.roles = attribute.roles;
        this.value = attribute.getValue();
        this.renderer = attribute.renderer;
    }

    public Attribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public Attribute(Object value, String role) {
        this.value = value;
        this.setRole(role);
    }

    @Deprecated
    public Attribute(Object value, String role, AttributeType type) {
        this.value = value;
        this.setType(type);
        this.setRole(role);
    }

    public Attribute(Object value, String role, String rendererName) {
        this.value = value;
        this.renderer = rendererName;
        this.setRole(role);
    }

    public Attribute(String name, Object value, String role, AttributeType type) {
        this.name = name;
        this.value = value;
        this.setType(type);
        this.setRole(role);
    }

    public String getRole() {
        String retValue = null;
        if (this.roles != null && !this.roles.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            Iterator<String> roleIt = this.roles.iterator();
            if (roleIt.hasNext()) {
                builder.append(roleIt.next());
                while (roleIt.hasNext()) {
                    builder.append(",");
                    builder.append(roleIt.next());
                }
                retValue = builder.toString();
            }
        }
        return retValue;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRole(String role) {
        if (role != null && role.trim().length() > 0) {
            String[] rolesStrings = role.split("\\s*,\\s*");
            this.roles = new HashSet<String>();
            for (int i = 0; i < rolesStrings.length; ++i) {
                this.roles.add(rolesStrings[i]);
            }
        } else {
            this.roles = null;
        }
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public AttributeType getType() {
        return AttributeType.getType(this.renderer);
    }

    public void setType(AttributeType type) {
        this.renderer = type.toString();
    }

    public String getRenderer() {
        return this.renderer;
    }

    public void setRenderer(String rendererName) {
        this.renderer = rendererName;
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setName(String name) {
        this.name = name;
    }

    public void setBody(String body) {
        if (body != null && body.length() != 0) {
            this.setValue(body);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeType {
        STRING("string"),
        DEFINITION("definition"),
        TEMPLATE("template"),
        OBJECT("object");

        private String stringRepresentation;
        private static Map<String, AttributeType> representation2type;

        public static AttributeType getType(String stringRepresentation) {
            return representation2type.get(stringRepresentation);
        }

        private AttributeType(String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        static {
            representation2type = new HashMap<String, AttributeType>();
            representation2type.put("string", STRING);
            representation2type.put("definition", DEFINITION);
            representation2type.put("template", TEMPLATE);
            representation2type.put("object", OBJECT);
        }
    }
}

