/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tiles.reflect.CannotAccessMethodException;
import org.apache.tiles.reflect.CannotInstantiateObjectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private ClassUtil() {
    }

    public static Object instantiate(String className) {
        return ClassUtil.instantiate(className, false);
    }

    public static Object instantiate(String className, boolean returnNull) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (original == null) {
            Thread.currentThread().setContextClassLoader(ClassUtil.class.getClassLoader());
        }
        try {
            Class<?> namedClass = Class.forName(className);
            Object obj = namedClass.newInstance();
            return obj;
        }
        catch (ClassNotFoundException e) {
            if (returnNull) {
                Object var4_8 = null;
                return var4_8;
            }
            throw new CannotInstantiateObjectException("Unable to resolve factory class: '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new CannotInstantiateObjectException("Unable to access factory class: '" + className + "'", e);
        }
        catch (InstantiationException e) {
            throw new CannotInstantiateObjectException("Unable to instantiate factory class: '" + className + "'. Make sure that this class has a default constructor", e);
        }
        finally {
            if (original == null) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    public static Method getForcedAccessibleMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method method;
        try {
            method = clazz.getMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new CannotAccessMethodException("Cannot access method '" + methodName + "' in class '" + clazz.getName() + "' for security reasons", e);
        }
        catch (NoSuchMethodException e) {
            throw new CannotAccessMethodException("The method '" + methodName + "' in class '" + clazz.getName() + "' does not exist", e);
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Object invokeMethod(Object obj, Method method, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            throw new CannotAccessMethodException("The arguments for '" + method.getName() + "' in class '" + obj.getClass().getName() + "' are not valid", e);
        }
        catch (IllegalAccessException e) {
            throw new CannotAccessMethodException("Cannot access '" + method.getName() + "' in class '" + obj.getClass().getName() + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new CannotAccessMethodException("An exception has been thrown inside '" + method.getName() + "' in class '" + obj.getClass().getName() + "'", e);
        }
    }
}

