/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.extras.module;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.reflect.ClassUtil;
import org.apache.tiles.request.servlet.wildcard.WildcardServletApplicationContext;
import org.apache.tiles.startup.TilesInitializer;

public class ModularTilesInitializer
implements TilesInitializer {
    private List<TilesInitializer> initializers;

    public void initialize(ApplicationContext preliminaryContext) {
        WildcardServletApplicationContext applicationContext = new WildcardServletApplicationContext((ServletContext)preliminaryContext.getContext());
        this.loadInitializers((ApplicationContext)applicationContext);
        for (TilesInitializer initializer : this.initializers) {
            initializer.initialize(preliminaryContext);
        }
    }

    public void destroy() {
        for (TilesInitializer initializer : this.initializers) {
            initializer.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitializers(ApplicationContext applicationContext) {
        this.initializers = new ArrayList<TilesInitializer>();
        try {
            Collection resources = applicationContext.getResources("classpath*:META-INF/MANIFEST.MF");
            ApplicationResource mainResource = applicationContext.getResource("/META-INF/MANIFEST.MF");
            if (mainResource != null) {
                resources.add(mainResource);
            }
            for (ApplicationResource resource : resources) {
                InputStream stream = resource.getInputStream();
                try {
                    String initializerName;
                    Manifest manifest = new Manifest(stream);
                    Attributes attributes = manifest.getMainAttributes();
                    if (attributes == null || (initializerName = attributes.getValue("Tiles-Initializer")) == null) continue;
                    TilesInitializer initializer = (TilesInitializer)ClassUtil.instantiate((String)initializerName);
                    this.initializers.add(initializer);
                }
                finally {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("Error getting manifest files", (Throwable)e);
        }
    }
}

