/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.freemarker.context;

import freemarker.core.Environment;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.tiles.ArrayStack;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.freemarker.FreeMarkerTilesException;
import org.apache.tiles.freemarker.io.NullWriter;
import org.apache.tiles.impl.NoSuchContainerException;
import org.apache.tiles.servlet.context.ServletUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FreeMarkerUtil {
    public static final String COMPOSE_STACK_ATTRIBUTE_NAME = "org.apache.tiles.template.COMPOSE_STACK";

    private FreeMarkerUtil() {
    }

    public static boolean isForceInclude(Environment env) {
        return ServletUtil.isForceInclude((HttpServletRequest)FreeMarkerUtil.getRequestHashModel(env).getRequest());
    }

    public static void setForceInclude(Environment env, boolean forceInclude) {
        ServletUtil.setForceInclude((HttpServletRequest)FreeMarkerUtil.getRequestHashModel(env).getRequest(), (boolean)forceInclude);
    }

    public static TilesContainer getContainer(Environment env, String key) {
        if (key == null) {
            key = "org.apache.tiles.CONTAINER";
        }
        return (TilesContainer)FreeMarkerUtil.getServletContextHashModel(env).getServlet().getServletContext().getAttribute(key);
    }

    public static void setCurrentContainer(Environment env, String key) {
        TilesContainer container = FreeMarkerUtil.getContainer(env, key);
        if (container == null) {
            throw new NoSuchContainerException("The container with the key '" + key + "' cannot be found");
        }
        FreeMarkerUtil.getRequestHashModel(env).getRequest().setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", (Object)container);
    }

    public static void setCurrentContainer(Environment env, TilesContainer container) {
        ServletUtil.setCurrentContainer((ServletRequest)FreeMarkerUtil.getRequestHashModel(env).getRequest(), (ServletContext)FreeMarkerUtil.getServletContextHashModel(env).getServlet().getServletContext(), (TilesContainer)container);
    }

    public static TilesContainer getCurrentContainer(Environment env) {
        return ServletUtil.getCurrentContainer((ServletRequest)FreeMarkerUtil.getRequestHashModel(env).getRequest(), (ServletContext)FreeMarkerUtil.getServletContextHashModel(env).getServlet().getServletContext());
    }

    public static HttpRequestHashModel getRequestHashModel(Environment env) {
        try {
            return (HttpRequestHashModel)env.getDataModel().get("Request");
        }
        catch (TemplateModelException e) {
            throw new FreeMarkerTilesException("Exception got when obtaining the request hash model", (Exception)((Object)e));
        }
    }

    public static ServletContextHashModel getServletContextHashModel(Environment env) {
        try {
            return (ServletContextHashModel)env.getDataModel().get("Application");
        }
        catch (TemplateModelException e) {
            throw new FreeMarkerTilesException("Exception got when obtaining the application hash model", (Exception)((Object)e));
        }
    }

    public static String getAsString(TemplateModel model) {
        try {
            return (String)DeepUnwrap.unwrap((TemplateModel)model);
        }
        catch (TemplateModelException e) {
            throw new FreeMarkerTilesException("Cannot unwrap a model", (Exception)((Object)e));
        }
    }

    public static boolean getAsBoolean(TemplateModel model, boolean defaultValue) {
        try {
            Boolean retValue = (Boolean)DeepUnwrap.unwrap((TemplateModel)model);
            return retValue != null ? retValue : defaultValue;
        }
        catch (TemplateModelException e) {
            throw new FreeMarkerTilesException("Cannot unwrap a model", (Exception)((Object)e));
        }
    }

    public static Object getAsObject(TemplateModel model) {
        try {
            return DeepUnwrap.unwrap((TemplateModel)model);
        }
        catch (TemplateModelException e) {
            throw new FreeMarkerTilesException("Cannot unwrap a model", (Exception)((Object)e));
        }
    }

    public static void setAttribute(Environment env, String name, Object obj, String scope) {
        if (scope == null) {
            scope = "page";
        }
        if ("page".equals(scope)) {
            try {
                TemplateModel model = env.getObjectWrapper().wrap(obj);
                env.setVariable(name, model);
            }
            catch (TemplateModelException e) {
                throw new FreeMarkerTilesException("Error when wrapping an object", (Exception)((Object)e));
            }
        } else if ("request".equals(scope)) {
            FreeMarkerUtil.getRequestHashModel(env).getRequest().setAttribute(name, obj);
        } else if ("session".equals(scope)) {
            FreeMarkerUtil.getRequestHashModel(env).getRequest().getSession().setAttribute(name, obj);
        } else if ("application".equals(scope)) {
            FreeMarkerUtil.getServletContextHashModel(env).getServlet().getServletContext().setAttribute(name, obj);
        }
    }

    public static ArrayStack<Object> getComposeStack(Environment env) {
        HttpServletRequest request = FreeMarkerUtil.getRequestHashModel(env).getRequest();
        ArrayStack composeStack = (ArrayStack)request.getAttribute(COMPOSE_STACK_ATTRIBUTE_NAME);
        if (composeStack == null) {
            composeStack = new ArrayStack();
            request.setAttribute(COMPOSE_STACK_ATTRIBUTE_NAME, (Object)composeStack);
        }
        return composeStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evaluateBody(TemplateDirectiveBody body) throws TemplateException, IOException {
        if (body != null) {
            NullWriter writer = new NullWriter();
            try {
                body.render((Writer)writer);
            }
            finally {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renderAsString(TemplateDirectiveBody body) throws TemplateException, IOException {
        String bodyString = null;
        if (body != null) {
            StringWriter stringWriter = new StringWriter();
            try {
                body.render((Writer)stringWriter);
            }
            finally {
                stringWriter.close();
            }
            bodyString = stringWriter.toString();
        }
        return bodyString;
    }
}

