/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.context;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.servlet.ServletTilesRequestContext;
import org.apache.tiles.jsp.context.JspUtil;
import org.apache.tiles.jsp.context.JspWriterResponse;

public class JspTilesRequestContext
extends ServletTilesRequestContext
implements TilesRequestContext {
    private static final Log LOG = LogFactory.getLog(JspTilesRequestContext.class);
    private PageContext pageContext;
    private JspWriterResponse response;

    public JspTilesRequestContext(ServletContext context, PageContext pageContext) {
        super(context, (HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse());
        this.pageContext = pageContext;
    }

    public void dispatch(String path) throws IOException {
        this.include(path);
    }

    public void include(String path) throws IOException {
        try {
            JspUtil.doInclude(this.pageContext, path, false);
        }
        catch (JspException e) {
            LOG.error((Object)("JSPException while including path '" + path + "'. "), (Throwable)e);
            throw new IOException("JSPException while including path '" + path + "'. " + e.getMessage());
        }
    }

    public HttpServletResponse getResponse() {
        if (this.response == null) {
            this.response = new JspWriterResponse(this.pageContext);
        }
        return this.response;
    }
}

