/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.context;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JspUtil {
    private static final Log LOG = LogFactory.getLog(JspUtil.class);
    private static Method include = null;

    public static void doInclude(PageContext pageContext, String uri, boolean flush) throws JspException {
        try {
            if (include != null) {
                include.invoke((Object)pageContext, uri, flush);
                return;
            }
        }
        catch (IllegalAccessException e) {
            LOG.debug((Object)"Could not find JSP 2.0 include method.  Using old one.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.debug((Object)"Unable to execute JSP 2.0 include method.  Trying old one.", (Throwable)e);
        }
        try {
            pageContext.include(uri);
        }
        catch (IOException e) {
            throw new JspException("IOException while including page.", (Throwable)e);
        }
        catch (ServletException e) {
            throw new JspException("ServletException while including page.", (Throwable)e);
        }
    }

    static {
        try {
            Class[] args = new Class[]{String.class, Boolean.TYPE};
            include = PageContext.class.getMethod("include", args);
        }
        catch (NoSuchMethodException e) {
            LOG.debug((Object)"Could not find JSP 2.0 include method.  Using old one that doesn't support configurable flushing.", (Throwable)e);
        }
    }
}

