/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.portlet.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletContext;
import org.apache.tiles.context.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PortletInitParamMap
implements Map<String, String> {
    private PortletContext context = null;

    public PortletInitParamMap(PortletContext context) {
        this.context = context;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.context.getInitParameter(this.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<String> values = this.values().iterator();
        while (values.hasNext()) {
            if (!value.equals(values.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> set = new HashSet<Map.Entry<String, String>>();
        Enumeration keys = this.context.getInitParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            set.add((Map.Entry<String, String>)new MapEntry((Object)key, (Object)this.context.getInitParameter(key), false));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        PortletContext otherContext = ((PortletInitParamMap)o).context;
        boolean retValue = true;
        PortletContext portletContext = this.context;
        synchronized (portletContext) {
            Enumeration attribs = this.context.getInitParameterNames();
            while (attribs.hasMoreElements() && retValue) {
                String parameterName = (String)attribs.nextElement();
                retValue = this.context.getInitParameter(parameterName).equals(otherContext.getInitParameter(parameterName));
            }
        }
        return retValue;
    }

    @Override
    public String get(Object key) {
        return this.context.getInitParameter(this.key(key));
    }

    @Override
    public int hashCode() {
        return this.context.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        Enumeration keys = this.context.getInitParameterNames();
        while (keys.hasMoreElements()) {
            set.add((String)keys.nextElement());
        }
        return set;
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration keys = this.context.getInitParameterNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration keys = this.context.getInitParameterNames();
        while (keys.hasMoreElements()) {
            list.add(this.context.getInitParameter((String)keys.nextElement()));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

