/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.portlet.context;

import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.portlet.context.NotAPortletEnvironmentException;
import org.apache.tiles.portlet.context.PortletTilesApplicationContext;
import org.apache.tiles.portlet.context.PortletTilesRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletTilesRequestContextFactory
implements TilesRequestContextFactory {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final int REQUEST_OBJECTS_LENGTH = 3;

    public PortletTilesRequestContextFactory() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The portlet environment is available, since the class " + PortletRequest.class + "is present"));
            }
        }
        catch (NoClassDefFoundError e) {
            throw new NotAPortletEnvironmentException("Cannot access portlet classes", e);
        }
    }

    public void init(Map<String, String> configParameters) {
    }

    public TilesRequestContext createRequestContext(TilesApplicationContext context, Object ... requestItems) {
        if (requestItems.length == 2 && requestItems[0] instanceof PortletRequest && requestItems[1] instanceof PortletResponse) {
            PortletContext portletContext = this.getPortletContext(context);
            if (portletContext != null) {
                return new PortletTilesRequestContext(context, portletContext, (PortletRequest)requestItems[0], (PortletResponse)requestItems[1]);
            }
        } else if (requestItems.length == 3 && requestItems[0] instanceof PortletRequest && requestItems[1] instanceof PortletResponse && requestItems[2] instanceof PortletContext) {
            return new PortletTilesRequestContext(context, (PortletContext)requestItems[2], (PortletRequest)requestItems[0], (PortletResponse)requestItems[1]);
        }
        return null;
    }

    protected PortletContext getPortletContext(TilesApplicationContext context) {
        if (context instanceof PortletTilesApplicationContext) {
            PortletTilesApplicationContext app = (PortletTilesApplicationContext)context;
            return app.getPortletContext();
        }
        return null;
    }
}

