/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.portlet.context;

import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.impl.NoSuchContainerException;

public final class PortletUtil {
    private PortletUtil() {
    }

    public static boolean isForceInclude(PortletRequest request) {
        Boolean retValue = (Boolean)request.getAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.FORCE_INCLUDE");
        return retValue != null && retValue != false;
    }

    public static void setForceInclude(PortletRequest request, boolean forceInclude) {
        Boolean retValue = forceInclude;
        request.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.FORCE_INCLUDE", (Object)retValue);
    }

    public static TilesContainer getContainer(PortletContext context) {
        return PortletUtil.getContainer(context, "org.apache.tiles.CONTAINER");
    }

    public static TilesContainer getContainer(PortletContext context, String key) {
        if (key == null) {
            key = "org.apache.tiles.CONTAINER";
        }
        return (TilesContainer)context.getAttribute(key);
    }

    public static void setContainer(PortletContext context, TilesContainer container) {
        PortletUtil.setContainer(context, container, "org.apache.tiles.CONTAINER");
    }

    public static void setContainer(PortletContext context, TilesContainer container, String key) {
        Log log = LogFactory.getLog(PortletUtil.class);
        if (key == null) {
            key = "org.apache.tiles.CONTAINER";
        }
        if (container == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Removing TilesContext for context: " + context.getClass().getName()));
            }
            context.removeAttribute(key);
        }
        if (container != null && log.isInfoEnabled()) {
            log.info((Object)("Publishing TilesContext for context: " + context.getClass().getName()));
        }
        context.setAttribute(key, (Object)container);
    }

    public static void setCurrentContainer(PortletRequest request, PortletContext context, String key) {
        TilesContainer container = PortletUtil.getContainer(context, key);
        if (container == null) {
            throw new NoSuchContainerException("The container with the key '" + key + "' cannot be found");
        }
        request.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", (Object)container);
    }

    public static void setCurrentContainer(PortletRequest request, PortletContext context, TilesContainer container) {
        if (container == null) {
            throw new NoSuchContainerException("The container cannot be null");
        }
        request.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", (Object)container);
    }

    public static TilesContainer getCurrentContainer(PortletRequest request, PortletContext context) {
        TilesContainer container = (TilesContainer)request.getAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY");
        if (container == null) {
            container = PortletUtil.getContainer(context);
            request.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", (Object)container);
        }
        return container;
    }
}

