/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.freemarker.extractor;

import freemarker.core.Environment;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.DeepUnwrap;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.tiles.request.attribute.AttributeExtractor;
import org.apache.tiles.request.freemarker.FreemarkerRequestException;

public class EnvironmentScopeExtractor
implements AttributeExtractor {
    private Environment request;

    public EnvironmentScopeExtractor(Environment request) {
        this.request = request;
    }

    public void removeValue(String name) {
        this.request.setVariable(name, null);
    }

    public Enumeration<String> getKeys() {
        try {
            return Collections.enumeration(this.request.getKnownVariableNames());
        }
        catch (TemplateModelException e) {
            throw new FreemarkerRequestException("Cannot iterate variable names correctly", e);
        }
    }

    public Object getValue(String key) {
        try {
            TemplateModel variable = this.request.getVariable(key);
            if (variable != null) {
                return DeepUnwrap.unwrap((TemplateModel)variable);
            }
            return null;
        }
        catch (TemplateModelException e) {
            throw new FreemarkerRequestException("Cannot get attribute with name '" + key + "'", e);
        }
    }

    public void setValue(String key, Object value) {
        try {
            TemplateModel model = this.request.getObjectWrapper().wrap(value);
            this.request.setVariable(key, model);
        }
        catch (TemplateModelException e) {
            throw new FreemarkerRequestException("Error when wrapping an object setting the '" + key + "' attribute", e);
        }
    }
}

