/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.template;

import org.apache.tiles.ArrayStack;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.Expression;
import org.apache.tiles.TilesContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutAttributeModel {
    public void start(ArrayStack<Object> composeStack) {
        Attribute attribute = new Attribute();
        composeStack.push((Object)attribute);
    }

    public void end(TilesContainer container, ArrayStack<Object> composeStack, String name, Object value, String expression, String body, String role, String type, boolean cascade, Object ... requestItems) {
        Attribute attribute = (Attribute)composeStack.pop();
        this.putAttributeInParent(attribute, container, composeStack, name, value, expression, body, role, type, cascade, requestItems);
    }

    public void execute(TilesContainer container, ArrayStack<Object> composeStack, String name, Object value, String expression, String body, String role, String type, boolean cascade, Object ... requestItems) {
        this.putAttributeInParent(new Attribute(), container, composeStack, name, value, expression, body, role, type, cascade, requestItems);
    }

    private void putAttributeInParent(Attribute attribute, TilesContainer container, ArrayStack<Object> composeStack, String name, Object value, String expression, String body, String role, String type, boolean cascade, Object ... requestItems) {
        Object obj;
        AttributeContext attributeContext = null;
        if (!composeStack.isEmpty() && (obj = composeStack.peek()) instanceof AttributeContext) {
            attributeContext = (AttributeContext)obj;
        }
        if (attributeContext == null) {
            attributeContext = container.getAttributeContext(requestItems);
        }
        if (value != null) {
            attribute.setValue(value);
        } else if (attribute.getValue() == null && body != null) {
            attribute.setValue((Object)body);
        }
        if (expression != null) {
            attribute.setExpressionObject(Expression.createExpressionFromDescribedExpression((String)expression));
        }
        if (role != null) {
            attribute.setRole(role);
        }
        if (type != null) {
            attribute.setRenderer(type);
        }
        attributeContext.putAttribute(name, attribute, cascade);
    }
}

