/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;

public class PSerializer<T extends P>
extends SimpleTypeSerializer<T> {
    private final Class<T> classOfP;
    private final ConcurrentHashMap<PFunctionId, CheckedFunction> methods = new ConcurrentHashMap();

    public PSerializer(DataType typeOfP, Class<T> classOfP) {
        super(typeOfP);
        this.classOfP = classOfP;
    }

    @Override
    protected T readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        String predicateName = context.readValue(buffer, String.class, false);
        int length = context.readValue(buffer, Integer.class, false);
        Object[] args = new Object[length];
        Class[] argumentClasses = new Class[length];
        for (int i = 0; i < length; ++i) {
            args[i] = context.read(buffer);
            argumentClasses[i] = args[i].getClass();
        }
        if ("and".equals(predicateName)) {
            return (T)((P)args[0]).and((Predicate)((P)args[1]));
        }
        if ("or".equals(predicateName)) {
            return (T)((P)args[0]).or((Predicate)((P)args[1]));
        }
        CheckedFunction f = this.getMethod(predicateName, argumentClasses);
        try {
            return (T)((P)f.apply(args));
        }
        catch (Exception ex) {
            throw new SerializationException(ex);
        }
    }

    private CheckedFunction getMethod(String predicateName, Class<?>[] argumentClasses) throws SerializationException {
        PFunctionId id = new PFunctionId(predicateName, argumentClasses);
        CheckedFunction<Object[], P> result = this.methods.get(id);
        if (result == null) {
            Method m;
            boolean collectionType = false;
            try {
                m = this.classOfP.getMethod(predicateName, argumentClasses);
            }
            catch (NoSuchMethodException ex0) {
                try {
                    m = this.classOfP.getMethod(predicateName, Collection.class);
                    collectionType = true;
                }
                catch (NoSuchMethodException ex1) {
                    try {
                        m = this.classOfP.getMethod(predicateName, Object.class);
                    }
                    catch (NoSuchMethodException ex2) {
                        throw new SerializationException("not found");
                    }
                }
            }
            Method finalMethod = m;
            try {
                if (Modifier.isStatic(m.getModifiers())) {
                    result = collectionType ? args -> (P)finalMethod.invoke(null, Arrays.asList(args)) : args -> (P)finalMethod.invoke(null, args);
                } else {
                    if (argumentClasses.length != 2) {
                        throw new IllegalStateException(String.format("Could not determine the form of P for %s and %s", predicateName, Arrays.asList(argumentClasses)));
                    }
                    result = args -> {
                        if (!(args[0] instanceof P) || !(args[1] instanceof P)) {
                            throw new IllegalStateException(String.format("Could not determine the form of P for %s and %s", predicateName, Arrays.asList(args)));
                        }
                        P firstP = (P)args[0];
                        P secondP = (P)args[1];
                        return (P)finalMethod.invoke((Object)firstP, secondP);
                    };
                }
                this.methods.put(id, result);
            }
            catch (Exception ex) {
                throw new SerializationException(ex);
            }
        }
        return result;
    }

    @Override
    protected void writeValue(T value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        boolean isConnectedP = value instanceof ConnectiveP;
        String predicateName = isConnectedP ? (value instanceof AndP ? "and" : "or") : value.getBiPredicate().toString();
        Object args = isConnectedP ? ((ConnectiveP)value).getPredicates() : value.getValue();
        List<Object> argsAsList = args instanceof Collection ? new ArrayList((Collection)args) : Collections.singletonList(args);
        int length = argsAsList.size();
        context.writeValue(predicateName, buffer, false);
        context.writeValue(length, buffer, false);
        for (Object o : argsAsList) {
            context.write(o, buffer);
        }
    }

    class PFunctionId {
        private final String predicateName;
        private final Class<?>[] argumentClasses;

        PFunctionId(String predicateName, Class<?>[] argumentClasses) {
            this.predicateName = predicateName;
            this.argumentClasses = argumentClasses;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PFunctionId that = (PFunctionId)o;
            return this.predicateName.equals(that.predicateName) && Arrays.equals(this.argumentClasses, that.argumentClasses);
        }

        public int hashCode() {
            int result = Objects.hash(this.predicateName);
            result = 31 * result + Arrays.hashCode(this.argumentClasses);
            return result;
        }
    }

    @FunctionalInterface
    static interface CheckedFunction<A, R> {
        public R apply(A var1) throws InvocationTargetException, IllegalAccessException;
    }
}

