/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.CollectionSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;

public class MetricsSerializer
extends SimpleTypeSerializer<Metrics> {
    private static final CollectionSerializer collectionSerializer = new CollectionSerializer(DataType.LIST);

    public MetricsSerializer() {
        super(DataType.METRICS);
    }

    @Override
    protected Metrics readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        MutableMetrics result = new MutableMetrics(context.readValue(buffer, String.class, false), context.readValue(buffer, String.class, false));
        result.setDuration(context.readValue(buffer, Long.class, false).longValue(), TimeUnit.NANOSECONDS);
        Map counts = context.readValue(buffer, Map.class, false);
        counts.forEach((arg_0, arg_1) -> ((MutableMetrics)result).setCount(arg_0, arg_1));
        Map annotations = context.readValue(buffer, Map.class, false);
        annotations.forEach((arg_0, arg_1) -> ((MutableMetrics)result).setAnnotation(arg_0, arg_1));
        Collection nestedMetrics = collectionSerializer.readValue(buffer, context);
        nestedMetrics.forEach(arg_0 -> ((MutableMetrics)result).addNested(arg_0));
        return result;
    }

    @Override
    protected void writeValue(Metrics value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        context.writeValue(value.getId(), buffer, false);
        context.writeValue(value.getName(), buffer, false);
        context.writeValue(value.getDuration(TimeUnit.NANOSECONDS), buffer, false);
        context.writeValue(value.getCounts(), buffer, false);
        context.writeValue(value.getAnnotations(), buffer, false);
        collectionSerializer.writeValue(value.getNested(), buffer, context);
    }
}

