/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.junit.Assert;
import org.junit.Test;

public class GremlinExecutorOverGraphTest
extends AbstractGremlinTest {
    private final BasicThreadFactory testingThreadFactory = new BasicThreadFactory.Builder().namingPattern("test-gremlin-executor-%d").build();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAllowTraversalToIterateInDifferentThreadThanOriginallyEvaluatedWithAutoCommit() throws Exception {
        ExecutorService evalExecutor = Executors.newSingleThreadExecutor((ThreadFactory)this.testingThreadFactory);
        GremlinExecutor gremlinExecutor = GremlinExecutor.build().afterSuccess(b -> {
            Graph graph = (Graph)b.get("g");
            if (graph.features().graph().supportsTransactions()) {
                graph.tx().commit();
            }
        }).executorService(evalExecutor).create();
        HashMap<String, GraphTraversalSource> bindings = new HashMap<String, GraphTraversalSource>();
        bindings.put("g", this.g);
        AtomicInteger vertexCount = new AtomicInteger(0);
        ExecutorService iterationExecutor = Executors.newSingleThreadExecutor((ThreadFactory)this.testingThreadFactory);
        ((CompletableFuture)gremlinExecutor.eval("g.V().out()", bindings).thenAcceptAsync(o -> {
            Iterator itty = (Iterator)o;
            itty.forEachRemaining(v -> vertexCount.incrementAndGet());
        }, (Executor)iterationExecutor)).join();
        Assert.assertEquals((long)6L, (long)vertexCount.get());
        gremlinExecutor.close();
        evalExecutor.shutdown();
        evalExecutor.awaitTermination(30000L, TimeUnit.MILLISECONDS);
        iterationExecutor.shutdown();
        iterationExecutor.awaitTermination(30000L, TimeUnit.MILLISECONDS);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAllowTraversalToIterateInDifferentThreadThanOriginallyEvaluatedWithoutAutoCommit() throws Exception {
        ExecutorService evalExecutor = Executors.newSingleThreadExecutor((ThreadFactory)this.testingThreadFactory);
        GremlinExecutor gremlinExecutor = GremlinExecutor.build().executorService(evalExecutor).create();
        HashMap<String, GraphTraversalSource> bindings = new HashMap<String, GraphTraversalSource>();
        bindings.put("g", this.g);
        AtomicInteger vertexCount = new AtomicInteger(0);
        ExecutorService iterationExecutor = Executors.newSingleThreadExecutor((ThreadFactory)this.testingThreadFactory);
        ((CompletableFuture)gremlinExecutor.eval("g.V().out()", bindings).thenAcceptAsync(o -> {
            Iterator itty = (Iterator)o;
            itty.forEachRemaining(v -> vertexCount.incrementAndGet());
        }, (Executor)iterationExecutor)).join();
        Assert.assertEquals((long)6L, (long)vertexCount.get());
        gremlinExecutor.close();
        evalExecutor.shutdown();
        evalExecutor.awaitTermination(30000L, TimeUnit.MILLISECONDS);
        iterationExecutor.shutdown();
        iterationExecutor.awaitTermination(30000L, TimeUnit.MILLISECONDS);
    }
}

