/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import javax.script.Bindings;
import javax.script.ScriptException;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.junit.Assert;
import org.junit.Test;

public class GremlinGroovyScriptEngineIntegrateTest
extends AbstractGremlinTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotBlowTheHeapParameterized() throws ScriptException {
        GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        String[] gremlins = new String[]{"g.V(xxx).out().toList()", "g.V(xxx).in().toList()", "g.V(xxx).out().out().out().toList()", "g.V(xxx).out().groupCount()"};
        long parameterizedStartTime = System.currentTimeMillis();
        System.out.println("Try to blow the heap with parameterized Gremlin.");
        try {
            for (int ix = 0; ix < 50001; ++ix) {
                Bindings bindings = engine.createBindings();
                bindings.put("g", (Object)this.g);
                bindings.put("xxx", (Object)(ix % 4 + 1));
                engine.eval(gremlins[ix % 4], bindings);
                if (ix <= 0 || ix % 5000 != 0) continue;
                System.out.println(String.format("%s scripts processed in %s (ms) - rate %s (ms/q).", ix, System.currentTimeMillis() - parameterizedStartTime, Double.valueOf(System.currentTimeMillis() - parameterizedStartTime) / Double.valueOf(ix)));
            }
        }
        catch (OutOfMemoryError oome) {
            Assert.fail((String)"Blew the heap - the cache should prevent this from happening.");
        }
    }

    @Test
    public void shouldNotBlowTheHeapUnparameterized() throws ScriptException {
        GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        long notParameterizedStartTime = System.currentTimeMillis();
        System.out.println("Try to blow the heap with non-parameterized Gremlin.");
        try {
            for (int ix = 0; ix < 15001; ++ix) {
                Bindings bindings = engine.createBindings();
                engine.eval(String.format("1+%s", ix), bindings);
                if (ix <= 0 || ix % 5000 != 0) continue;
                System.out.println(String.format("%s scripts processed in %s (ms) - rate %s (ms/q).", ix, System.currentTimeMillis() - notParameterizedStartTime, Double.valueOf(System.currentTimeMillis() - notParameterizedStartTime) / Double.valueOf(ix)));
            }
        }
        catch (OutOfMemoryError oome) {
            Assert.fail((String)"Blew the heap - the cache should prevent this from happening.");
        }
    }
}

