/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import java.awt.Color;
import javax.script.Bindings;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.groovy.CompilerCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.AllowColorSandboxExtension;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.CompileStaticCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.TinkerPopSandboxExtension;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GremlinGroovyScriptEngineTinkerPopSandboxTest
extends AbstractGremlinTest {
    @Test
    public void shouldNotEvalAsTheMethodIsNotWhiteListed() throws Exception {
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(TinkerPopSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            engine.eval("java.lang.Math.abs(123)");
            Assert.fail((String)"Should have a compile error because class/method is not white listed");
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Not authorized to call this method"));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldEvalOnGAsTheMethodIsWhiteListed() throws Exception {
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(TinkerPopSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            Bindings bindings = engine.createBindings();
            bindings.put("g", (Object)this.g);
            Assert.assertEquals((Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next(), (Object)engine.eval("g.V(" + this.convertToVertexId("marko") + ").next()", bindings));
            Assert.assertEquals((Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).out(new String[]{"created"}).count().next(), (Object)engine.eval("g.V(" + this.convertToVertexId("marko") + ").out(\"created\").count().next()", bindings));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotEvalColorWhenCallingMethods() throws Exception {
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(AllowColorSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            Assert.assertEquals((Object)new Color(255, 255, 255), (Object)engine.eval("new java.awt.Color(255,255,255)"));
        }
        try {
            engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});
            var3_4 = null;
            try {
                engine.eval("new java.awt.Color(255,255,255).getRed()");
                Assert.fail((String)"Type checking should have forced an error as 'getRed()' is not authorized - just Color construction");
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (engine != null) {
                    if (var3_4 != null) {
                        try {
                            engine.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        engine.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"Not authorized to call this method"));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotEvalColorWhenCallingProperties() throws Exception {
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(AllowColorSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            Assert.assertEquals((Object)new Color(255, 255, 255), (Object)engine.eval("new java.awt.Color(255,255,255)"));
        }
        try {
            engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});
            var3_4 = null;
            try {
                engine.eval("new java.awt.Color(255,255,255).red");
                Assert.fail((String)"Type checking should have forced an error as 'red' is not authorized - just Color construction");
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (engine != null) {
                    if (var3_4 != null) {
                        try {
                            engine.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        engine.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"Not authorized to call this method"));
        }
    }
}

