/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.plugin.dsl.credential;

import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.groovy.plugin.dsl.credential.CredentialGraph;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CredentialGraphTest
extends AbstractGremlinTest {
    @Test
    public void shouldCreateUser() {
        Vertex v = CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        Assert.assertEquals((Object)"stephen", (Object)v.value("username"));
        Assert.assertEquals((Object)"user", (Object)v.label());
        Assert.assertNotEquals((Object)"secret", (Object)v.value("password"));
        MatcherAssert.assertThat((Object)v.value("password").toString().length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void shouldRemoveUser() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((long)1L, (long)CredentialGraph.credentials((Graph)this.graph).removeUser("stephen"));
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotRemoveUser() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((long)0L, (long)CredentialGraph.credentials((Graph)this.graph).removeUser("stephanie"));
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldFindUser() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("marko", "secret");
        Vertex stephen = CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("daniel", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((Object)stephen, (Object)CredentialGraph.credentials((Graph)this.graph).findUser("stephen"));
    }

    @Test
    public void shouldNotFindUser() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("marko", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("daniel", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertNull((Object)CredentialGraph.credentials((Graph)this.graph).findUser("stephanie"));
    }

    @Test
    public void shouldCountUsers() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("marko", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("daniel", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((long)3L, (long)CredentialGraph.credentials((Graph)this.graph).countUsers());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIfFindingMultipleUsers() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertNull((Object)CredentialGraph.credentials((Graph)this.graph).findUser("stephen"));
    }
}

