/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import java.io.File;
import java.util.Arrays;
import javax.script.Bindings;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.groovy.CompilerCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.CompileStaticCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.FileSandboxExtension;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GremlinGroovyScriptEngineFileSandboxTest
extends AbstractGremlinTest {
    @Before
    public void setup() throws Exception {
        super.setup();
        if (System.getProperty("gremlinServerSandbox") == null) {
            File f = TestHelper.generateTempFileFromResource(this.graph.getClass(), GremlinGroovyScriptEngineFileSandboxTest.class, (String)"sandbox.yaml", (String)".yaml");
            System.setProperty("gremlinServerSandbox", f.getAbsolutePath());
        }
    }

    @AfterClass
    public static void destroy() {
        System.clearProperty("gremlinServerSandbox");
    }

    @Test
    public void shouldSuccessfullyInstantiateGroovyScriptEngineWithEmptyStaticVariableTyping() throws Exception {
        File f = TestHelper.generateTempFileFromResource(this.graph.getClass(), GremlinGroovyScriptEngineFileSandboxTest.class, (String)"sandbox-empty-static-variable-types.yaml", (String)".yaml");
        System.setProperty("gremlinServerSandbox", f.getAbsolutePath());
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(FileSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            Assert.assertEquals((Object)123, (Object)engine.eval("java.lang.Math.abs(-123)"));
            Assert.assertThat((Object)engine.eval("new Boolean(true)"), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)engine.eval("new Boolean(true).toString()"), (Matcher)CoreMatchers.is((Object)"true"));
        }
    }

    @Test
    public void shouldEvalAsTheMethodIsWhiteListed() throws Exception {
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(FileSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            Assert.assertEquals((Object)123, (Object)engine.eval("java.lang.Math.abs(-123)"));
            Assert.assertThat((Object)engine.eval("new Boolean(true)"), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)engine.eval("new Boolean(true).toString()"), (Matcher)CoreMatchers.is((Object)"true"));
        }
    }

    @Test
    public void shouldEvalAsGroovyPropertiesWhenWhiteListed() throws Exception {
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(FileSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            Assert.assertThat((Object)Arrays.equals("test".getBytes(), (byte[])engine.eval("'test'.bytes")), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void shouldPreventMaliciousStuffWithSystemButAllowSomeMethodsOnSystem() throws Exception {
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(FileSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            Assert.assertThat((Object)((Long)engine.eval("System.currentTimeMillis()")), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            Assert.assertThat((Object)((Long)engine.eval("System.nanoTime()")), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            engine.eval("System.exit(0)");
            Assert.fail((String)"Should have a compile error because class/method is not white listed");
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Not authorized to call this method"));
        }
    }

    @Test
    public void shouldPreventMaliciousStuffWithFile() throws Exception {
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(FileSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            engine.eval("java.nio.file.FileSystems.getDefault()");
            Assert.fail((String)"Should have a compile error because class/method is not white listed");
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Not authorized to call this method"));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldEvalOnGAsTheMethodIsWhiteListed() throws Exception {
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(FileSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            Bindings bindings = engine.createBindings();
            bindings.put("g", (Object)this.g);
            bindings.put("marko", this.convertToVertexId("marko"));
            Assert.assertEquals((Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next(), (Object)engine.eval("g.V(marko).next()", bindings));
            Assert.assertEquals((Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).out(new String[]{"created"}).count().next(), (Object)engine.eval("g.V(marko).out(\"created\").count().next()", bindings));
        }
    }
}

