/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import java.util.Arrays;
import javax.script.Bindings;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.groovy.CompilerCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.CompileStaticCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.SandboxExtension;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.TypeCheckedCustomizerProvider;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GremlinGroovyScriptEngineSandboxedStandardTest
extends AbstractGremlinTest {
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public CompilerCustomizerProvider notSandboxed;
    @Parameterized.Parameter(value=2)
    public CompilerCustomizerProvider sandboxed;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({TypeCheckedCustomizerProvider.class.getSimpleName(), new TypeCheckedCustomizerProvider(), new TypeCheckedCustomizerProvider(SandboxExtension.class.getName())}, {CompileStaticCustomizerProvider.class.getSimpleName(), new CompileStaticCustomizerProvider(), new CompileStaticCustomizerProvider(SandboxExtension.class.getName())});
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldEvalGraphTraversalSource() throws Exception {
        Bindings bindings;
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();){
            bindings = engine.createBindings();
            bindings.put("g", (Object)this.g);
            bindings.put("marko", this.convertToVertexId("marko"));
            Assert.assertEquals((Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next(), (Object)engine.eval("g.V(marko).next()", bindings));
        }
        try {
            engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{this.notSandboxed});
            var2_3 = null;
            try {
                bindings = engine.createBindings();
                bindings.put("g", (Object)this.g);
                bindings.put("marko", this.convertToVertexId("marko"));
                engine.eval("g.V(marko).next()", bindings);
                Assert.fail((String)"Type checking should have forced an error as 'g' is not defined");
            }
            catch (Throwable bindings2) {
                var2_3 = bindings2;
                throw bindings2;
            }
            finally {
                if (engine != null) {
                    if (var2_3 != null) {
                        try {
                            engine.close();
                        }
                        catch (Throwable bindings2) {
                            var2_3.addSuppressed(bindings2);
                        }
                    } else {
                        engine.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"The variable [g] is undeclared."));
        }
        engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{this.sandboxed});
        var2_3 = null;
        try {
            bindings = engine.createBindings();
            bindings.put("g", (Object)this.g);
            bindings.put("marko", this.convertToVertexId("marko"));
            Assert.assertEquals((Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next(), (Object)engine.eval("g.V(marko).next()", bindings));
            Assert.assertEquals((Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).out(new String[]{"created"}).count().next(), (Object)engine.eval("g.V(marko).out(\"created\").count().next()", bindings));
        }
        catch (Throwable throwable) {
            var2_3 = throwable;
            throw throwable;
        }
        finally {
            if (engine != null) {
                if (var2_3 != null) {
                    try {
                        engine.close();
                    }
                    catch (Throwable throwable) {
                        var2_3.addSuppressed(throwable);
                    }
                } else {
                    engine.close();
                }
            }
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldEvalGraph() throws Exception {
        Bindings bindings;
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();){
            bindings = engine.createBindings();
            bindings.put("graph", (Object)this.graph);
            bindings.put("marko", this.convertToVertexId("marko"));
            Assert.assertEquals(this.graph.vertices(new Object[]{this.convertToVertexId("marko")}).next(), (Object)engine.eval("graph.vertices(marko).next()", bindings));
        }
        try {
            engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{this.notSandboxed});
            var2_4 = null;
            try {
                bindings = engine.createBindings();
                bindings.put("graph", (Object)this.graph);
                bindings.put("marko", this.convertToVertexId("marko"));
                Assert.assertEquals(this.graph.vertices(new Object[]{this.convertToVertexId("marko")}).next(), (Object)engine.eval("graph.vertices(marko).next()", bindings));
                Assert.fail((String)"Type checking should have forced an error as 'graph' is not defined");
            }
            catch (Throwable bindings2) {
                var2_4 = bindings2;
                throw bindings2;
            }
            finally {
                if (engine != null) {
                    if (var2_4 != null) {
                        try {
                            engine.close();
                        }
                        catch (Throwable bindings2) {
                            var2_4.addSuppressed(bindings2);
                        }
                    } else {
                        engine.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"The variable [graph] is undeclared."));
        }
        try {
            engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{this.notSandboxed});
            var2_4 = null;
            try {
                bindings = engine.createBindings();
                bindings.put("graph", (Object)this.graph);
                bindings.put("x", this.convertToVertexId("marko"));
                Assert.assertEquals(this.graph.vertices(new Object[]{this.convertToVertexId("marko")}).next(), (Object)engine.eval("graph.vertices(x).next()", bindings));
                Assert.fail((String)"Type checking should have forced an error as 'graph' is not defined");
            }
            catch (Throwable bindings3) {
                var2_4 = bindings3;
                throw bindings3;
            }
            finally {
                if (engine != null) {
                    if (var2_4 != null) {
                        try {
                            engine.close();
                        }
                        catch (Throwable bindings3) {
                            var2_4.addSuppressed(bindings3);
                        }
                    } else {
                        engine.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"The variable [graph] is undeclared."));
        }
        engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{this.sandboxed});
        var2_4 = null;
        try {
            bindings = engine.createBindings();
            bindings.put("graph", (Object)this.graph);
            bindings.put("marko", this.convertToVertexId("marko"));
            Assert.assertEquals(this.graph.vertices(new Object[]{this.convertToVertexId("marko")}).next(), (Object)engine.eval("graph.vertices(marko).next()", bindings));
        }
        catch (Throwable bindings4) {
            var2_4 = bindings4;
            throw bindings4;
        }
        finally {
            if (engine != null) {
                if (var2_4 != null) {
                    try {
                        engine.close();
                    }
                    catch (Throwable bindings4) {
                        var2_4.addSuppressed(bindings4);
                    }
                } else {
                    engine.close();
                }
            }
        }
        engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{this.sandboxed});
        var2_4 = null;
        try {
            bindings = engine.createBindings();
            bindings.put("graph", (Object)this.graph);
            bindings.put("x", this.convertToVertexId("marko"));
            Assert.assertEquals(this.graph.vertices(new Object[]{this.convertToVertexId("marko")}).next(), (Object)engine.eval("graph.vertices(x).next()", bindings));
        }
        catch (Throwable throwable) {
            var2_4 = throwable;
            throw throwable;
        }
        finally {
            if (engine != null) {
                if (var2_4 != null) {
                    try {
                        engine.close();
                    }
                    catch (Throwable throwable) {
                        var2_4.addSuppressed(throwable);
                    }
                } else {
                    engine.close();
                }
            }
        }
    }
}

