/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential;

import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential.CredentialGraph;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CredentialGraphTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldCreateUser() {
        Vertex v = CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        Assert.assertEquals((Object)"stephen", (Object)v.value("username"));
        Assert.assertEquals((Object)"user", (Object)v.label());
        Assert.assertNotEquals((Object)"secret", (Object)v.value("password"));
        MatcherAssert.assertThat((Object)v.value("password").toString().length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")
    public void shouldRemoveUser() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((long)1L, (long)CredentialGraph.credentials((Graph)this.graph).removeUser("stephen"));
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotRemoveUser() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((long)0L, (long)CredentialGraph.credentials((Graph)this.graph).removeUser("stephanie"));
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldFindUser() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("marko", "secret");
        Vertex stephen = CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("daniel", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((Object)stephen, (Object)CredentialGraph.credentials((Graph)this.graph).findUser("stephen"));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotFindUser() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("marko", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("daniel", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertNull((Object)CredentialGraph.credentials((Graph)this.graph).findUser("stephanie"));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldCountUsers() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("marko", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("daniel", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((long)3L, (long)CredentialGraph.credentials((Graph)this.graph).countUsers());
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldThrowIfFindingMultipleUsers() {
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        CredentialGraph.credentials((Graph)this.graph).createUser("stephen", "secret");
        MatcherAssert.assertThat((Object)this.graph.vertices(new Object[0]).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertNull((Object)CredentialGraph.credentials((Graph)this.graph).findUser("stephen"));
    }
}

