/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.groovy.CompilerCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.DefaultImportCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.NoImportCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.config.YamlConfiguration;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class GremlinGroovyScriptEngineOverGraphTest
extends AbstractGremlinTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldDoSomeGremlin() throws Exception {
        GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        ArrayList list = new ArrayList();
        Bindings bindings = engine.createBindings();
        bindings.put("g", (Object)this.g);
        bindings.put("marko", this.convertToVertexId("marko"));
        bindings.put("temp", (Object)list);
        Assert.assertEquals((long)list.size(), (long)0L);
        engine.eval("g.V(marko).out().fill(temp)", bindings);
        Assert.assertEquals((long)list.size(), (long)3L);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldLoadImports() throws Exception {
        GremlinGroovyScriptEngine engineNoImports = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{NoImportCustomizerProvider.INSTANCE});
        try {
            engineNoImports.eval("Vertex.class.getName()");
            Assert.fail((String)"Should have thrown an exception because no imports were supplied");
        }
        catch (Exception se) {
            Assert.assertTrue((boolean)(se instanceof ScriptException));
        }
        GremlinGroovyScriptEngine engineWithImports = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{new DefaultImportCustomizerProvider()});
        engineWithImports.put("g", this.g);
        Assert.assertEquals((Object)Vertex.class.getName(), (Object)engineWithImports.eval("Vertex.class.getName()"));
        Assert.assertEquals((Object)2L, (Object)engineWithImports.eval("g.V().has('age',gt(30)).count().next()"));
        Assert.assertEquals((Object)Direction.IN, (Object)engineWithImports.eval("Direction.IN"));
        Assert.assertEquals((Object)Direction.OUT, (Object)engineWithImports.eval("Direction.OUT"));
        Assert.assertEquals((Object)Direction.BOTH, (Object)engineWithImports.eval("Direction.BOTH"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldLoadStandardImportsAndThenAddToThem() throws Exception {
        GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{new DefaultImportCustomizerProvider()});
        engine.put("g", (Object)this.g);
        Assert.assertEquals((Object)Vertex.class.getName(), (Object)engine.eval("Vertex.class.getName()"));
        Assert.assertEquals((Object)2L, (Object)engine.eval("g.V().has('age',gt(30)).count().next()"));
        Assert.assertEquals((Object)Direction.IN, (Object)engine.eval("Direction.IN"));
        Assert.assertEquals((Object)Direction.OUT, (Object)engine.eval("Direction.OUT"));
        Assert.assertEquals((Object)Direction.BOTH, (Object)engine.eval("Direction.BOTH"));
        try {
            engine.eval("YamlConfiguration.class.getName()");
            Assert.fail((String)"Should have thrown an exception because no imports were supplied");
        }
        catch (Exception se) {
            Assert.assertTrue((boolean)(se instanceof ScriptException));
        }
        engine.addImports(new HashSet<String>(Arrays.asList("import " + YamlConfiguration.class.getCanonicalName())));
        engine.put("g", (Object)this.g);
        Assert.assertEquals((Object)YamlConfiguration.class.getName(), (Object)engine.eval("YamlConfiguration.class.getName()"));
        Assert.assertEquals((Object)Vertex.class.getName(), (Object)engine.eval("Vertex.class.getName()"));
        Assert.assertEquals((Object)2L, (Object)engine.eval("g.V().has('age',gt(30)).count().next()"));
        Assert.assertEquals((Object)Direction.IN, (Object)engine.eval("Direction.IN"));
        Assert.assertEquals((Object)Direction.OUT, (Object)engine.eval("Direction.OUT"));
        Assert.assertEquals((Object)Direction.BOTH, (Object)engine.eval("Direction.BOTH"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    public void shouldProperlyHandleBindings() throws Exception {
        GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        engine.put("g", this.g);
        engine.put("marko", this.convertToVertexId("marko"));
        Assert.assertEquals((Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next(), (Object)engine.eval("g.V(marko).next()"));
        Bindings bindings = engine.createBindings();
        bindings.put("g", (Object)this.g);
        bindings.put("s", (Object)"marko");
        bindings.put("f", (Object)Float.valueOf(0.5f));
        bindings.put("i", (Object)1);
        bindings.put("b", (Object)true);
        bindings.put("l", (Object)100L);
        bindings.put("d", (Object)1.55555);
        Assert.assertEquals((Object)engine.eval("g.E().has('weight',f).next()", bindings), (Object)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next());
        Assert.assertEquals((Object)engine.eval("g.V().has('name',s).next()", bindings), (Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next());
        Assert.assertEquals((Object)engine.eval("g.V().sideEffect{it.get().property('bbb',it.get().value('name')=='marko')}.iterate();g.V().has('bbb',b).next()", bindings), (Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next());
        Assert.assertEquals((Object)engine.eval("g.V().sideEffect{it.get().property('iii',it.get().value('name')=='marko'?1:0)}.iterate();g.V().has('iii',i).next()", bindings), (Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next());
        Assert.assertEquals((Object)engine.eval("g.V().sideEffect{it.get().property('lll',it.get().value('name')=='marko'?100l:0l)}.iterate();g.V().has('lll',l).next()", bindings), (Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next());
        Assert.assertEquals((Object)engine.eval("g.V().sideEffect{it.get().property('ddd',it.get().value('name')=='marko'?1.55555d:0)}.iterate();g.V().has('ddd',d).next()", bindings), (Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldClearBindingsBetweenEvals() throws Exception {
        GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        engine.put("g", this.g);
        engine.put("marko", this.convertToVertexId("marko"));
        Assert.assertEquals((Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next(), (Object)engine.eval("g.V(marko).next()"));
        Bindings bindings = engine.createBindings();
        bindings.put("g", (Object)this.g);
        bindings.put("s", (Object)"marko");
        Assert.assertEquals((Object)engine.eval("g.V().has('name',s).next()", bindings), (Object)this.g.V(new Object[]{this.convertToVertexId("marko")}).next());
        try {
            engine.eval("g.V().has('name',s).next()");
            Assert.fail((String)"This should have failed because s is no longer bound");
        }
        catch (Exception ex) {
            Throwable t = ExceptionUtils.getRootCause((Throwable)ex);
            Assert.assertEquals(MissingPropertyException.class, t.getClass());
            Assert.assertTrue((boolean)t.getMessage().startsWith("No such property: s for class"));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldBeThreadSafe() throws Exception {
        GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        int runs = 500;
        CountDownLatch latch = new CountDownLatch(runs);
        final List<String> names = Arrays.asList("marko", "peter", "josh", "vadas", "stephen", "pavel", "matthias");
        final Random random = new Random();
        for (int i = 0; i < runs; ++i) {
            new Thread("test-thread-safe-" + i, (ScriptEngine)engine, latch){
                final /* synthetic */ ScriptEngine val$engine;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$engine = scriptEngine;
                    this.val$latch = countDownLatch;
                    super(x0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String name = (String)names.get(random.nextInt(names.size() - 1));
                    try {
                        Bindings bindings = this.val$engine.createBindings();
                        bindings.put("g", (Object)GremlinGroovyScriptEngineOverGraphTest.this.g);
                        bindings.put("name", (Object)name);
                        Object result = this.val$engine.eval("t = g.V().has('name',name); if(t.hasNext()) { t } else { null }", bindings);
                        if (name.equals("stephen") || name.equals("pavel") || name.equals("matthias")) {
                            Assert.assertNull((Object)result);
                        } else {
                            Assert.assertNotNull((Object)result);
                        }
                    }
                    catch (ScriptException e) {
                        Assert.assertFalse((boolean)true);
                    }
                    finally {
                        if (GremlinGroovyScriptEngineOverGraphTest.this.graph.features().graph().supportsTransactions()) {
                            GremlinGroovyScriptEngineOverGraphTest.this.g.tx().rollback();
                        }
                    }
                    this.val$latch.countDown();
                }
            }.start();
        }
        latch.await();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldBeThreadSafeOnCompiledScript() throws Exception {
        final GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        final CompiledScript script = engine.compile("t = g.V().has('name',name); if(t.hasNext()) { t } else { null }");
        int runs = 500;
        final CountDownLatch latch = new CountDownLatch(runs);
        final List<String> names = Arrays.asList("marko", "peter", "josh", "vadas", "stephen", "pavel", "matthias");
        final Random random = new Random();
        for (int i = 0; i < runs; ++i) {
            new Thread("test-thread-safety-on-compiled-script-" + i){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String name = (String)names.get(random.nextInt(names.size() - 1));
                    try {
                        Bindings bindings = engine.createBindings();
                        bindings.put("g", (Object)GremlinGroovyScriptEngineOverGraphTest.this.g);
                        bindings.put("name", (Object)name);
                        Object result = script.eval(bindings);
                        if (name.equals("stephen") || name.equals("pavel") || name.equals("matthias")) {
                            Assert.assertNull((Object)result);
                        } else {
                            Assert.assertNotNull((Object)result);
                        }
                    }
                    catch (ScriptException e) {
                        Assert.assertFalse((boolean)true);
                    }
                    finally {
                        if (GremlinGroovyScriptEngineOverGraphTest.this.graph.features().graph().supportsTransactions()) {
                            GremlinGroovyScriptEngineOverGraphTest.this.g.tx().rollback();
                        }
                    }
                    latch.countDown();
                }
            }.start();
        }
        latch.await();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldEvalGlobalClosuresEvenAfterEvictionOfClass() throws ScriptException {
        GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        Bindings bindings = engine.createBindings();
        bindings.put("g", (Object)this.g);
        bindings.put("marko", this.convertToVertexId("marko"));
        bindings.put("vadas", this.convertToVertexId("vadas"));
        engine.eval("def isVadas(v){v.value('name')=='vadas'}", bindings);
        Assert.assertEquals((Object)true, (Object)engine.eval("isVadas(g.V(vadas).next())", bindings));
        bindings.put("#jsr223.groovy.engine.keep.globals", (Object)"phantom");
        engine.eval("def isMarko(v){v.value('name')=='marko'}", bindings);
        try {
            engine.eval("isMarko(g.V(marko).next())", bindings);
            Assert.fail((String)"the isMarko function should not be present");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((Object)true, (Object)engine.eval("def isMarko(v){v.value('name')=='marko'}; isMarko(g.V(marko).next())", bindings));
        try {
            engine.eval("isMarko(g.V(marko).next())", bindings);
            Assert.fail((String)"the isMarko function should not be present");
        }
        catch (Exception exception) {
            // empty catch block
        }
        bindings.remove("#jsr223.groovy.engine.keep.globals");
        Assert.assertEquals((Object)true, (Object)engine.eval("isVadas(g.V(vadas).next())", bindings));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAllowFunctionsUsedInClosure() throws ScriptException {
        GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        Bindings bindings = engine.createBindings();
        bindings.put("g", (Object)this.g);
        bindings.put("#jsr223.groovy.engine.keep.globals", (Object)"phantom");
        bindings.put("vadas", this.convertToVertexId("vadas"));
        Assert.assertEquals((Object)this.g.V(new Object[]{this.convertToVertexId("vadas")}).next(), (Object)engine.eval("def isVadas(v){v.value('name')=='vadas'};g.V().filter{isVadas(it.get())}.next()", bindings));
        engine.reset();
        try {
            engine.eval("isVadas(g.V(vadas).next())", bindings);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        bindings.remove("#jsr223.groovy.engine.keep.globals");
        engine.eval("def isVadas(v){v.value('name')=='vadas'}", bindings);
        Assert.assertEquals((Object)true, (Object)engine.eval("isVadas(g.V(vadas).next())", bindings));
        Assert.assertEquals((Object)this.g.V(new Object[]{this.convertToVertexId("vadas")}).next(), (Object)engine.eval("g.V().filter{isVadas(it.get())}.next()", bindings));
    }

    @Test
    @Ignore
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    public void shouldAllowUseOfClasses() throws ScriptException {
        GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        Bindings bindings = engine.createBindings();
        bindings.put("g", (Object)this.g);
        bindings.put("vadas", this.convertToVertexId("vadas"));
        Assert.assertEquals((Object)true, (Object)engine.eval("class c { static def isVadas(v){v.value('name')=='vadas'}};c.isVadas(g.V(vadas).next())", bindings));
        engine.reset();
        try {
            engine.eval("c.isVadas(g.V(vadas).next())", bindings);
            Assert.fail((String)"Function should be gone");
        }
        catch (Exception exception) {
            // empty catch block
        }
        engine.eval("class c { static def isVadas(v){v.name=='vadas'}};null;", bindings);
        Assert.assertEquals((Object)true, (Object)engine.eval("c.isVadas(g.V(vadas).next())", bindings));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldProcessUTF8Query() throws Exception {
        Vertex nonUtf8 = this.graph.addVertex(new Object[]{"name", "marko", "age", 29});
        Vertex utf8Name = this.graph.addVertex(new Object[]{"name", "\u8f49\u6ce8", "age", 32});
        GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        engine.put("g", this.g);
        Traversal eval = (Traversal)engine.eval("g.V().has('name', 'marko')");
        Assert.assertEquals((Object)nonUtf8, (Object)eval.next());
        eval = (Traversal)engine.eval("g.V().has('name','\u8f49\u6ce8')");
        Assert.assertEquals((Object)utf8Name, (Object)eval.next());
    }
}

