/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import javax.script.Bindings;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.groovy.CompilerCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.BlockSomeVariablesSandboxExtension;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.groovy.jsr223.RebindAllVariableTypesSandboxExtension;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.CompileStaticCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.SandboxExtension;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GremlinGroovyScriptEngineSandboxCustomTest
extends AbstractGremlinTest {
    @Test
    public void shouldEvalGVariableAsSomethingOtherThanGraphTraversalSource() throws Exception {
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(SandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            Bindings bindings = engine.createBindings();
            bindings.put("g", (Object)1);
            engine.eval("g+1", bindings);
            Assert.fail((String)"Should have a compile error because 'g' is expected to be GraphTraversalSource");
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Cannot find matching method"));
        }
        CompileStaticCustomizerProvider customSandbox = new CompileStaticCustomizerProvider(RebindAllVariableTypesSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{customSandbox});){
            Bindings bindings = engine.createBindings();
            bindings.put("g", (Object)1);
            Assert.assertEquals((Object)2, (Object)engine.eval("g+1", bindings));
        }
    }

    @Test
    public void shouldEvalGraphVariableAsSomethingOtherThanGraph() throws Exception {
        CompileStaticCustomizerProvider standardSandbox = new CompileStaticCustomizerProvider(SandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{standardSandbox});){
            Bindings bindings = engine.createBindings();
            bindings.put("graph", (Object)1);
            engine.eval("graph+1", bindings);
            Assert.fail((String)"Should have a compile error because 'graph' is expected to be Graph");
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Cannot find matching method"));
        }
        CompileStaticCustomizerProvider customSandbox = new CompileStaticCustomizerProvider(RebindAllVariableTypesSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{customSandbox});){
            Bindings bindings = engine.createBindings();
            bindings.put("graph", (Object)1);
            Assert.assertEquals((Object)2, (Object)engine.eval("graph+1", bindings));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotEvalBecauseSandboxIsConfiguredToNotAcceptGraphInstances() throws Exception {
        CompileStaticCustomizerProvider customSandbox = new CompileStaticCustomizerProvider(BlockSomeVariablesSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{customSandbox});){
            Bindings bindings = engine.createBindings();
            bindings.put("graph", (Object)this.graph);
            engine.eval("graph.vertices()", bindings);
            Assert.fail((String)"Should have a compile error because sandbox does not allow Graph");
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"The variable [graph] is undeclared."));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotEvalBecauseSandboxIsConfiguredToNotAcceptShortVarNames() throws Exception {
        CompileStaticCustomizerProvider customSandbox = new CompileStaticCustomizerProvider(BlockSomeVariablesSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{customSandbox});){
            Bindings bindings = engine.createBindings();
            bindings.put("g", (Object)1);
            engine.eval("g+1", bindings);
            Assert.fail((String)"Should have a compile error because sandbox wants names > 3");
        }
        catch (Exception ex) {
            Assert.assertEquals(MultipleCompilationErrorsException.class, ex.getCause().getClass());
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"The variable [g] is undeclared."));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldEvalAsVariableRequirementsAreInRangeOfSandbox() throws Exception {
        CompileStaticCustomizerProvider customSandbox = new CompileStaticCustomizerProvider(BlockSomeVariablesSandboxExtension.class.getName());
        try (GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{customSandbox});){
            Bindings bindings = engine.createBindings();
            bindings.put("graph", (Object)1);
            Assert.assertEquals((Object)2, (Object)engine.eval("graph+1", bindings));
        }
    }
}

