/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.server.Channelizer;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.MultiTaskSession;
import org.apache.tinkerpop.gremlin.server.handler.Session;
import org.apache.tinkerpop.gremlin.server.handler.SessionException;
import org.apache.tinkerpop.gremlin.server.handler.SessionTask;
import org.apache.tinkerpop.gremlin.server.handler.SingleTaskSession;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class UnifiedHandler
extends SimpleChannelInboundHandler<RequestMessage> {
    private static final Logger logger = LoggerFactory.getLogger(UnifiedHandler.class);
    protected final Settings settings;
    protected final GraphManager graphManager;
    protected final GremlinExecutor gremlinExecutor;
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final ExecutorService sessionExecutor;
    protected final Channelizer channelizer;
    protected final ConcurrentMap<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    protected static final Set<String> INVALID_BINDINGS_KEYS = new HashSet<String>();

    public UnifiedHandler(Settings settings, GraphManager graphManager, GremlinExecutor gremlinExecutor, ScheduledExecutorService scheduledExecutorService, Channelizer channelizer) {
        this.settings = settings;
        this.graphManager = graphManager;
        this.gremlinExecutor = gremlinExecutor;
        this.scheduledExecutorService = scheduledExecutorService;
        this.channelizer = channelizer;
        this.sessionExecutor = gremlinExecutor.getExecutorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, RequestMessage msg) throws Exception {
        try {
            try {
                this.validateRequest(msg, this.graphManager);
            }
            catch (SessionException we) {
                ctx.writeAndFlush((Object)we.getResponseMessage());
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            Optional optMultiTaskSession = msg.optionalArgs("session");
            String sessionId = optMultiTaskSession.orElse(msg.getRequestId().toString());
            SessionTask sessionTask = new SessionTask(msg, ctx, this.settings, this.graphManager, this.gremlinExecutor, this.scheduledExecutorService);
            if (this.sessions.containsKey(sessionId)) {
                Session session = (Session)this.sessions.get(sessionId);
                if (!session.isBoundTo(ctx.channel())) {
                    String sessionClosedMessage = String.format("Session %s is not bound to the connecting client", sessionId);
                    ResponseMessage response = ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(sessionClosedMessage).create();
                    ctx.writeAndFlush((Object)response);
                    return;
                }
                if (session.isAcceptingTasks() && !session.submitTask(sessionTask)) {
                    String sessionClosedMessage = String.format("Session %s is no longer accepting requests as it has been closed", sessionId);
                    ResponseMessage response = ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(sessionClosedMessage).create();
                    ctx.writeAndFlush((Object)response);
                }
            } else {
                long sessionLife;
                Session session = optMultiTaskSession.isPresent() ? this.createMultiTaskSession(sessionTask, sessionId) : this.createSingleTaskSession(sessionTask, sessionId);
                Future<?> sessionFuture = this.sessionExecutor.submit(session);
                session.setSessionFuture(sessionFuture);
                this.sessions.put(sessionId, session);
                long seto = sessionTask.getRequestTimeout();
                long l = sessionLife = optMultiTaskSession.isPresent() ? this.settings.sessionLifetimeTimeout : seto;
                if (seto > 0L) {
                    ScheduledFuture<?> sessionCancelFuture = this.scheduledExecutorService.schedule(() -> session.triggerTimeout(sessionLife, optMultiTaskSession.isPresent()), sessionLife, TimeUnit.MILLISECONDS);
                    session.setSessionCancelFuture(sessionCancelFuture);
                }
            }
        }
        catch (RejectedExecutionException ree) {
            logger.warn(ree.getMessage());
            ResponseMessage response = ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.TOO_MANY_REQUESTS).statusMessage("Rate limiting").create();
            ctx.writeAndFlush((Object)response);
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    protected void validateRequest(RequestMessage message, GraphManager graphManager) throws SessionException {
        String msg;
        String msg2;
        if (!message.getOp().equals("close") && !message.optionalArgs("gremlin").isPresent()) {
            String msg3 = String.format("A message with a [%s] op code requires a [%s] argument.", message.getOp(), "gremlin");
            throw new SessionException(msg3, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg3).create());
        }
        if (message.optionalArgs("session").isPresent()) {
            Optional mtx = message.optionalArgs("manageTransaction");
            if (mtx.isPresent() && !(mtx.get() instanceof Boolean)) {
                String msg4 = String.format("%s argument must be of type boolean", "manageTransaction");
                throw new SessionException(msg4, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg4).create());
            }
            Optional msae = message.optionalArgs("maintainStateAfterException");
            if (msae.isPresent() && !(msae.get() instanceof Boolean)) {
                String msg5 = String.format("%s argument must be of type boolean", "maintainStateAfterException");
                throw new SessionException(msg5, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg5).create());
            }
        } else {
            if (message.optionalArgs("manageTransaction").isPresent()) {
                String msg6 = String.format("%s argument only applies to requests made for sessions", "manageTransaction");
                throw new SessionException(msg6, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg6).create());
            }
            if (message.optionalArgs("maintainStateAfterException").isPresent()) {
                String msg7 = String.format("%s argument only applies to requests made for sessions", "maintainStateAfterException");
                throw new SessionException(msg7, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg7).create());
            }
        }
        if (message.optionalArgs("bindings").isPresent()) {
            Map bindings = (Map)message.getArgs().get("bindings");
            if (IteratorUtils.anyMatch(bindings.keySet().iterator(), k -> null == k || !(k instanceof String))) {
                msg2 = String.format("The [%s] message is using one or more invalid binding keys - they must be of type String and cannot be null", "eval");
                throw new SessionException(msg2, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg2).create());
            }
            Set badBindings = IteratorUtils.set((Iterator)IteratorUtils.filter(bindings.keySet().iterator(), INVALID_BINDINGS_KEYS::contains));
            if (!badBindings.isEmpty()) {
                String msg8 = String.format("The [%s] message supplies one or more invalid parameters key of [%s] - these are reserved names.", "eval", badBindings);
                throw new SessionException(msg8, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg8).create());
            }
            if (IteratorUtils.count((Iterator)IteratorUtils.filter(bindings.keySet().iterator(), k -> !k.toString().startsWith("#jsr223"))) > (long)this.settings.maxParameters) {
                String msg9 = String.format("The [%s] message contains %s bindings which is more than is allowed by the server %s configuration", "eval", bindings.size(), this.settings.maxParameters);
                throw new SessionException(msg9, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg9).create());
            }
        }
        if (message.getOp().equals("eval")) {
            if (!(message.optionalArgs("gremlin").get() instanceof String)) {
                msg = String.format("A message with [%s] op code requires a [%s] argument that is of type %s.", "eval", "gremlin", String.class.getSimpleName());
                throw new SessionException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
            }
        } else if (message.getOp().equals("bytecode")) {
            if (!(message.optionalArgs("gremlin").get() instanceof Bytecode)) {
                msg = String.format("A message with [%s] op code requires a [%s] argument that is of type %s.", "bytecode", "gremlin", Bytecode.class.getSimpleName());
                throw new SessionException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
            }
            Optional aliases = message.optionalArgs("aliases");
            if (!aliases.isPresent()) {
                msg2 = String.format("A message with [%s] op code requires a [%s] argument.", "bytecode", "aliases");
                throw new SessionException(msg2, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg2).create());
            }
            if (((Map)aliases.get()).size() != 1 || !((Map)aliases.get()).containsKey("g")) {
                msg2 = String.format("A message with [%s] op code requires the [%s] argument to be a Map containing one alias assignment named '%s'.", "bytecode", "aliases", "g");
                throw new SessionException(msg2, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg2).create());
            }
            String traversalSourceBindingForAlias = (String)((Map)aliases.get()).values().iterator().next();
            if (!graphManager.getTraversalSourceNames().contains(traversalSourceBindingForAlias)) {
                String msg10 = String.format("The traversal source [%s] for alias [%s] is not configured on the server.", traversalSourceBindingForAlias, "g");
                throw new SessionException(msg10, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg10).create());
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!this.channelizer.supportsIdleMonitor()) {
            return;
        }
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            if (e.state() == IdleState.READER_IDLE) {
                logger.info("Closing channel - client is disconnected after idle period of " + this.settings.idleConnectionTimeout + " " + ctx.channel().id().asShortText());
                ctx.close();
            } else if (e.state() == IdleState.WRITER_IDLE && this.settings.keepAliveInterval > 0L) {
                logger.info("Checking channel - sending ping to client after idle period of " + this.settings.keepAliveInterval + " " + ctx.channel().id().asShortText());
                ctx.writeAndFlush(this.channelizer.createIdleDetectionMessage());
            }
        }
    }

    protected Session createSingleTaskSession(SessionTask sessionTask, String sessionId) {
        return new SingleTaskSession(sessionTask, sessionId, this.sessions);
    }

    protected Session createMultiTaskSession(SessionTask sessionTask, String sessionId) {
        return new MultiTaskSession(sessionTask, sessionId, this.sessions);
    }

    public boolean isActiveSession(String sessionId) {
        return this.sessions.containsKey(sessionId);
    }

    public int getActiveSessionCount() {
        return this.sessions.size();
    }

    static {
        INVALID_BINDINGS_KEYS.addAll(Arrays.asList(T.id.name(), T.key.name(), T.label.name(), T.value.name(), T.id.getAccessor(), T.key.getAccessor(), T.label.getAccessor(), T.value.getAccessor(), T.id.getAccessor().toUpperCase(), T.key.getAccessor().toUpperCase(), T.label.getAccessor().toUpperCase(), T.value.getAccessor().toUpperCase()));
        for (Column column : Column.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Order.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Operator.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Scope.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Pop.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
    }
}

