/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.node.ArrayNode;
import org.apache.tinkerpop.shaded.jackson.databind.node.ObjectNode;
import org.javatuples.Quartet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHandlerUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpHandlerUtil.class);
    static final Meter errorMeter = MetricManager.INSTANCE.getMeter(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"errors"}));
    private static final String ARGS_BINDINGS_DOT = "bindings.";
    private static final String ARGS_ALIASES_DOT = "aliases.";
    private static final ObjectMapper mapper = new ObjectMapper();

    static Quartet<String, Map<String, Object>, String, Map<String, String>> getRequestArguments(FullHttpRequest request) {
        JsonNode languageNode;
        JsonNode aliasesNode;
        JsonNode body;
        if (request.method() == HttpMethod.GET) {
            QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
            List gremlinParms = (List)decoder.parameters().get("gremlin");
            if (null == gremlinParms || gremlinParms.size() == 0) {
                throw new IllegalArgumentException("no gremlin script supplied");
            }
            String script = (String)gremlinParms.get(0);
            if (script.isEmpty()) {
                throw new IllegalArgumentException("no gremlin script supplied");
            }
            HashMap bindings = new HashMap();
            decoder.parameters().entrySet().stream().filter(kv -> ((String)kv.getKey()).startsWith(ARGS_BINDINGS_DOT)).forEach(kv -> bindings.put(((String)kv.getKey()).substring(ARGS_BINDINGS_DOT.length()), ((List)kv.getValue()).get(0)));
            HashMap aliases = new HashMap();
            decoder.parameters().entrySet().stream().filter(kv -> ((String)kv.getKey()).startsWith(ARGS_ALIASES_DOT)).forEach(kv -> aliases.put(((String)kv.getKey()).substring(ARGS_ALIASES_DOT.length()), (String)((List)kv.getValue()).get(0)));
            List languageParms = (List)decoder.parameters().get("language");
            String language = null == languageParms || languageParms.size() == 0 ? null : (String)languageParms.get(0);
            return Quartet.with((Object)script, bindings, (Object)language, aliases);
        }
        try {
            body = mapper.readTree(request.content().toString(CharsetUtil.UTF_8));
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("body could not be parsed", ioe);
        }
        JsonNode scriptNode = body.get("gremlin");
        if (null == scriptNode) {
            throw new IllegalArgumentException("no gremlin script supplied");
        }
        JsonNode bindingsNode = body.get("bindings");
        if (bindingsNode != null && !bindingsNode.isObject()) {
            throw new IllegalArgumentException("bindings must be a Map");
        }
        HashMap bindings = new HashMap();
        if (bindingsNode != null) {
            bindingsNode.fields().forEachRemaining(kv -> bindings.put((String)kv.getKey(), HttpHandlerUtil.fromJsonNode((JsonNode)kv.getValue())));
        }
        if ((aliasesNode = body.get("aliases")) != null && !aliasesNode.isObject()) {
            throw new IllegalArgumentException("aliases must be a Map");
        }
        HashMap aliases = new HashMap();
        if (aliasesNode != null) {
            aliasesNode.fields().forEachRemaining(kv -> aliases.put((String)kv.getKey(), ((JsonNode)kv.getValue()).asText()));
        }
        String language = null == (languageNode = body.get("language")) ? null : languageNode.asText();
        return Quartet.with((Object)scriptNode.asText(), bindings, (Object)language, aliases);
    }

    private static Object fromJsonNode(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isObject()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ObjectNode objectNode = (ObjectNode)node;
            Iterator iterator = objectNode.fieldNames();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                map.put(key, HttpHandlerUtil.fromJsonNode(objectNode.get(key)));
            }
            return map;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            ArrayList<Object> array = new ArrayList<Object>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                array.add(HttpHandlerUtil.fromJsonNode(arrayNode.get(i)));
            }
            return array;
        }
        if (node.isFloatingPointNumber()) {
            return node.asDouble();
        }
        if (node.isIntegralNumber()) {
            return node.asLong();
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        return node.asText();
    }

    static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, String message, boolean keepAlive) {
        HttpHandlerUtil.sendError(ctx, status, message, Optional.empty(), keepAlive);
    }

    static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, String message, Optional<Throwable> t, boolean keepAlive) {
        if (t.isPresent()) {
            logger.warn(String.format("Invalid request - responding with %s and %s", status, message), t.get());
        } else {
            logger.warn(String.format("Invalid request - responding with %s and %s", status, message));
        }
        errorMeter.mark();
        ObjectNode node = mapper.createObjectNode();
        node.put("message", message);
        if (t.isPresent()) {
            node.put("Exception-Class", t.get().getClass().getName());
            ArrayNode exceptionList = node.putArray("exceptions");
            ExceptionUtils.getThrowableList((Throwable)t.get()).forEach(throwable -> exceptionList.add(throwable.getClass().getName()));
            node.put("stackTrace", ExceptionUtils.getStackTrace((Throwable)t.get()));
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)node.toString(), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        HttpHandlerUtil.sendAndCleanupConnection(ctx, keepAlive, (FullHttpResponse)response);
    }

    static void sendAndCleanupConnection(ChannelHandlerContext ctx, boolean keepAlive, FullHttpResponse response) {
        HttpUtil.setKeepAlive((HttpMessage)response, (boolean)keepAlive);
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        ChannelFuture flushPromise = ctx.writeAndFlush((Object)response);
        if (!keepAlive) {
            flushPromise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

