/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.traversal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.jsr223.JavaTranslator;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Failure;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.util.BytecodeHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.handler.Frame;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.op.AbstractOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.server.util.TraverserIterator;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.TemporaryException;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraversalOpProcessor
extends AbstractOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TraversalOpProcessor.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit.org.apache.tinkerpop.gremlin.server");
    public static final String OP_PROCESSOR_NAME = "traversal";
    public static final Timer traversalOpTimer = MetricManager.INSTANCE.getTimer(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"op", "traversal"}));
    private static final Bindings EMPTY_BINDINGS = new SimpleBindings();

    public TraversalOpProcessor() {
        super(false);
    }

    @Override
    public String getName() {
        return OP_PROCESSOR_NAME;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public ThrowingConsumer<Context> select(Context context) throws OpProcessorException {
        ThrowingConsumer op;
        RequestMessage message = context.getRequestMessage();
        logger.debug("Selecting processor for RequestMessage {}", (Object)message);
        switch (message.getOp()) {
            case "bytecode": {
                TraversalOpProcessor.validateTraversalSourceAlias(context, message, TraversalOpProcessor.validateTraversalRequest(message));
                op = this::iterateBytecodeTraversal;
                break;
            }
            case "invalid": {
                String msgInvalid = String.format("Message could not be parsed.  Check the format of the request. [%s]", message);
                throw new OpProcessorException(msgInvalid, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).statusMessage(msgInvalid).create());
            }
            default: {
                String msgDefault = String.format("Message with op code [%s] is not recognized.", message.getOp());
                throw new OpProcessorException(msgDefault, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).statusMessage(msgDefault).create());
            }
        }
        return op;
    }

    private static void validateTraversalSourceAlias(Context ctx, RequestMessage message, Map<String, String> aliases) throws OpProcessorException {
        String traversalSourceBindingForAlias = aliases.values().iterator().next();
        if (!ctx.getGraphManager().getTraversalSourceNames().contains(traversalSourceBindingForAlias)) {
            String msg = String.format("The traversal source [%s] for alias [%s] is not configured on the server.", traversalSourceBindingForAlias, "g");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
    }

    private static Map<String, String> validateTraversalRequest(RequestMessage message) throws OpProcessorException {
        if (!message.optionalArgs("gremlin").isPresent()) {
            String msg = String.format("A message with [%s] op code requires a [%s] argument.", "bytecode", "gremlin");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        if (!(message.optionalArgs("gremlin").get() instanceof Bytecode)) {
            String msg = String.format("A message with [%s] op code requires a [%s] argument that is of type %s.", "bytecode", "gremlin", Bytecode.class.getSimpleName());
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        return TraversalOpProcessor.validatedAliases(message).get();
    }

    private static Optional<Map<String, String>> validatedAliases(RequestMessage message) throws OpProcessorException {
        Optional aliases = message.optionalArgs("aliases");
        if (!aliases.isPresent()) {
            String msg = String.format("A message with [%s] op code requires a [%s] argument.", "bytecode", "aliases");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        if (((Map)aliases.get()).size() != 1 || !((Map)aliases.get()).containsKey("g")) {
            String msg = String.format("A message with [%s] op code requires the [%s] argument to be a Map containing one alias assignment named '%s'.", "bytecode", "aliases", "g");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        return aliases;
    }

    private void iterateBytecodeTraversal(Context context) throws Exception {
        Traversal.Admin traversal;
        RequestMessage msg = context.getRequestMessage();
        Settings settings = context.getSettings();
        logger.debug("Traversal request {} for in thread {}", (Object)msg.getRequestId(), (Object)Thread.currentThread().getName());
        Object bytecodeObj = msg.getArgs().get("gremlin");
        Bytecode bytecode = (Bytecode)bytecodeObj;
        Map aliases = (Map)msg.optionalArgs("aliases").get();
        Map args = msg.getArgs();
        long seto = args.containsKey("evaluationTimeout") ? ((Number)args.get("evaluationTimeout")).longValue() : context.getSettings().getEvaluationTimeout();
        GraphManager graphManager = context.getGraphManager();
        String traversalSourceName = (String)aliases.entrySet().iterator().next().getValue();
        TraversalSource g = graphManager.getTraversalSource(traversalSourceName);
        try {
            Optional lambdaLanguage = BytecodeHelper.getLambdaLanguage((Bytecode)bytecode);
            traversal = !lambdaLanguage.isPresent() ? JavaTranslator.of((TraversalSource)g).translate(bytecode) : context.getGremlinExecutor().eval(bytecode, EMPTY_BINDINGS, (String)lambdaLanguage.get(), traversalSourceName);
        }
        catch (ScriptException ex) {
            logger.error("Traversal contains a lambda that cannot be compiled", (Throwable)ex);
            throw new OpProcessorException("Traversal contains a lambda that cannot be compiled", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_EVALUATION).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
        }
        catch (Exception ex) {
            logger.error("Could not deserialize the Traversal instance", (Throwable)ex);
            throw new OpProcessorException("Could not deserialize the Traversal instance", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_SERIALIZATION).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
        }
        if (settings.enableAuditLog.booleanValue()) {
            String address;
            AuthenticatedUser user = (AuthenticatedUser)context.getChannelHandlerContext().channel().attr(StateKey.AUTHENTICATED_USER).get();
            if (null == user) {
                user = AuthenticatedUser.ANONYMOUS_USER;
            }
            if ((address = context.getChannelHandlerContext().channel().remoteAddress().toString()).startsWith("/") && address.length() > 1) {
                address = address.substring(1);
            }
            auditLogger.info("User {} with address {} requested: {}", new Object[]{user.getName(), address, bytecode});
        }
        Timer.Context timerContext = traversalOpTimer.time();
        FutureTask<Void> evalFuture = new FutureTask<Void>(() -> {
            context.setStartedResponse();
            Graph graph = g.getGraph();
            try {
                this.beforeProcessing(graph, context);
                try {
                    traversal.applyStrategies();
                    this.handleIterator(context, new TraverserIterator(traversal), graph);
                }
                catch (Exception ex) {
                    Optional<Throwable> possibleSpecialException;
                    Throwable t = ex;
                    if (ex instanceof UndeclaredThrowableException) {
                        t = t.getCause();
                    }
                    if ((possibleSpecialException = TraversalOpProcessor.determineIfSpecialException(ex)).isPresent()) {
                        Throwable special = possibleSpecialException.get();
                        ResponseMessage.Builder specialResponseMsg = ResponseMessage.build((RequestMessage)msg).statusMessage(special.getMessage()).statusAttributeException(special);
                        if (special instanceof TemporaryException) {
                            specialResponseMsg.code(ResponseStatusCode.SERVER_ERROR_TEMPORARY);
                        } else if (special instanceof Failure) {
                            Failure failure = (Failure)special;
                            specialResponseMsg.code(ResponseStatusCode.SERVER_ERROR_FAIL_STEP).statusAttribute("failStepMessage", (Object)failure.format());
                        }
                        context.writeAndFlush(specialResponseMsg.create());
                    } else if (t instanceof InterruptedException || t instanceof TraversalInterruptedException) {
                        graphManager.onQueryError(msg, t);
                        String errorMessage = String.format("A timeout occurred during traversal evaluation of [%s] - consider increasing the limit given to evaluationTimeout", msg);
                        logger.warn(errorMessage);
                        context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage(errorMessage).statusAttributeException((Throwable)ex).create());
                    } else {
                        logger.warn(String.format("Exception processing a Traversal on iteration for request [%s].", msg.getRequestId()), (Throwable)ex);
                        context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
                    }
                    this.onError(graph, context, ex);
                }
            }
            catch (Exception ex) {
                Optional<Throwable> possibleSpecialException = TraversalOpProcessor.determineIfSpecialException(ex);
                if (possibleSpecialException.isPresent()) {
                    Throwable special = possibleSpecialException.get();
                    ResponseMessage.Builder specialResponseMsg = ResponseMessage.build((RequestMessage)msg).statusMessage(special.getMessage()).statusAttributeException(special);
                    if (special instanceof TemporaryException) {
                        specialResponseMsg.code(ResponseStatusCode.SERVER_ERROR_TEMPORARY);
                    } else if (special instanceof Failure) {
                        Failure failure = (Failure)special;
                        specialResponseMsg.code(ResponseStatusCode.SERVER_ERROR_FAIL_STEP).statusAttribute("failStepMessage", (Object)failure.format());
                    }
                    context.writeAndFlush(specialResponseMsg.create());
                } else {
                    logger.warn(String.format("Exception processing a Traversal on request [%s].", msg.getRequestId()), (Throwable)ex);
                    context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(ex.getMessage()).statusAttributeException((Throwable)ex).create());
                }
                this.onError(graph, context, ex);
            }
            finally {
                timerContext.stop();
            }
            return null;
        });
        try {
            Future<?> executionFuture = context.getGremlinExecutor().getExecutorService().submit(evalFuture);
            if (seto > 0L) {
                context.getScheduledExecutorService().schedule(() -> {
                    executionFuture.cancel(true);
                    if (!context.getStartedResponse()) {
                        context.sendTimeoutResponse();
                    }
                }, seto, TimeUnit.MILLISECONDS);
            }
        }
        catch (RejectedExecutionException ree) {
            context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.TOO_MANY_REQUESTS).statusMessage("Rate limiting").create());
        }
    }

    protected void beforeProcessing(Graph graph, Context ctx) {
        GraphManager graphManager = ctx.getGraphManager();
        RequestMessage msg = ctx.getRequestMessage();
        graphManager.beforeQueryStart(msg);
        if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
            graph.tx().rollback();
        }
    }

    protected void onError(Graph graph, Context ctx, Throwable error) {
        GraphManager graphManager = ctx.getGraphManager();
        RequestMessage msg = ctx.getRequestMessage();
        graphManager.onQueryError(msg, error);
        if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
            graph.tx().rollback();
        }
    }

    protected void onTraversalSuccess(Graph graph, Context ctx) {
        GraphManager graphManager = ctx.getGraphManager();
        RequestMessage msg = ctx.getRequestMessage();
        graphManager.onQuerySuccess(msg);
        if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
            graph.tx().commit();
        }
    }

    protected void handleIterator(Context context, Iterator itty, Graph graph) throws InterruptedException {
        ChannelHandlerContext nettyContext = context.getChannelHandlerContext();
        RequestMessage msg = context.getRequestMessage();
        Settings settings = context.getSettings();
        MessageSerializer serializer = (MessageSerializer)nettyContext.channel().attr(StateKey.SERIALIZER).get();
        boolean useBinary = (Boolean)nettyContext.channel().attr(StateKey.USE_BINARY).get();
        boolean warnOnce = false;
        if (!itty.hasNext()) {
            Map<String, Object> attributes = this.generateStatusAttributes(nettyContext, msg, ResponseStatusCode.NO_CONTENT, itty, settings);
            this.onTraversalSuccess(graph, context);
            context.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.NO_CONTENT).statusAttributes(attributes).create());
            return;
        }
        int resultIterationBatchSize = msg.optionalArgs("batchSize").orElse(settings.resultIterationBatchSize);
        ArrayList<Object> aggregate = new ArrayList<Object>(resultIterationBatchSize);
        boolean hasMore = itty.hasNext();
        while (hasMore) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            boolean forceFlush = this.isForceFlushed(nettyContext, msg, itty);
            if (aggregate.size() < resultIterationBatchSize && itty.hasNext() && !forceFlush) {
                aggregate.add(itty.next());
            }
            if (!nettyContext.channel().isActive()) {
                this.onError(graph, context, (Throwable)new ChannelException("Channel is not active - cannot write any more results"));
                break;
            }
            if (nettyContext.channel().isActive() && nettyContext.channel().isWritable()) {
                if (!forceFlush && aggregate.size() != resultIterationBatchSize && itty.hasNext()) continue;
                ResponseStatusCode code = itty.hasNext() ? ResponseStatusCode.PARTIAL_CONTENT : ResponseStatusCode.SUCCESS;
                Map<String, Object> metadata = this.generateResultMetaData(nettyContext, msg, code, itty, settings);
                Map<String, Object> statusAttrb = this.generateStatusAttributes(nettyContext, msg, code, itty, settings);
                Frame frame = null;
                try {
                    frame = TraversalOpProcessor.makeFrame(context, msg, serializer, useBinary, aggregate, code, metadata, statusAttrb);
                }
                catch (Exception ex) {
                    if (frame != null) {
                        frame.tryRelease();
                    }
                    this.onError(graph, context, ex);
                    break;
                }
                hasMore = itty.hasNext();
                try {
                    if (hasMore) {
                        aggregate = new ArrayList(resultIterationBatchSize);
                    } else {
                        this.onTraversalSuccess(graph, context);
                    }
                }
                catch (Exception ex) {
                    if (frame != null) {
                        frame.tryRelease();
                    }
                    throw ex;
                }
                if (!hasMore) {
                    this.iterateComplete(nettyContext, msg, itty);
                }
                context.writeAndFlush(code, frame);
                continue;
            }
            if (!warnOnce) {
                logger.warn("Pausing response writing as writeBufferHighWaterMark exceeded on {} - writing will continue once client has caught up", (Object)msg);
                warnOnce = true;
            }
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }
}

