/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.bulkloading;

import java.lang.reflect.Field;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.BulkLoader;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.BulkLoaderVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.IncrementalBulkLoader;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.junit.Assert;
import org.junit.Test;

public class BulkLoaderVertexProgramTest
extends AbstractGremlinProcessTest {
    private BulkLoader getBulkLoader(BulkLoaderVertexProgram blvp) throws Exception {
        Field field = BulkLoaderVertexProgram.class.getDeclaredField("bulkLoader");
        field.setAccessible(true);
        return (BulkLoader)field.get(blvp);
    }

    private Graph getTargetGraph() {
        BaseConfiguration configuration = new BaseConfiguration();
        configuration.setProperty("gremlin.graph", (Object)"org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph");
        return GraphFactory.open((Configuration)configuration);
    }

    @Test
    public void shouldUseIncrementalBulkLoaderByDefault() throws Exception {
        BulkLoader loader = this.getBulkLoader(BulkLoaderVertexProgram.build().create(this.graph));
        Assert.assertTrue((boolean)(loader instanceof IncrementalBulkLoader));
        Assert.assertTrue((boolean)loader.keepOriginalIds());
        Assert.assertFalse((boolean)loader.useUserSuppliedIds());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldStoreOriginalIds() throws Exception {
        BulkLoader loader = this.getBulkLoader(BulkLoaderVertexProgram.build().userSuppliedIds(false).create(this.graph));
        Assert.assertFalse((boolean)loader.useUserSuppliedIds());
        Graph target = this.getTargetGraph();
        this.graph.vertices(new Object[0]).forEachRemaining(v -> loader.getOrCreateVertex(v, target, target.traversal()));
        target.vertices(new Object[0]).forEachRemaining(v -> Assert.assertTrue((boolean)v.property(loader.getVertexIdProperty()).isPresent()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotStoreOriginalIds() throws Exception {
        BulkLoader loader = this.getBulkLoader(BulkLoaderVertexProgram.build().userSuppliedIds(true).create(this.graph));
        Assert.assertTrue((boolean)loader.useUserSuppliedIds());
        Graph target = this.getTargetGraph();
        this.graph.vertices(new Object[0]).forEachRemaining(v -> loader.getOrCreateVertex(v, target, target.traversal()));
        target.vertices(new Object[0]).forEachRemaining(v -> Assert.assertFalse((boolean)v.property(loader.getVertexIdProperty()).isPresent()));
    }
}

