/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.function.FunctionUtils;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@ExceptionCoverage(exceptionClass=Vertex.Exceptions.class, methods={"multiplePropertiesExistForProvidedKey"})
@RunWith(value=Enclosed.class)
public class VertexPropertyTest
extends AbstractGremlinTest {

    public static class VertexPropertyProperties
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
        public void shouldReturnEmptyIfNoMetaProperties() {
            Vertex v = this.graph.addVertex(new Object[0]);
            VertexProperty vp = v.property(VertexProperty.Cardinality.single, "name", (Object)"marko", new Object[0]);
            Assert.assertEquals((Object)Property.empty(), (Object)vp.property("name"));
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")})
        public void shouldSupportPropertiesOnMultiProperties() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko", "age", 34});
            this.tryCommit(this.graph, g -> {
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                VertexPropertyProperties.assertVertexEdgeCounts(1, 0);
                Assert.assertEquals((Object)v.property("name"), (Object)v.property("name").property("acl", (Object)"public").element());
                Assert.assertEquals((Object)v.property("age"), (Object)v.property("age").property("acl", (Object)"private").element());
            });
            v.property("name").property("acl", (Object)"public");
            v.property("age").property("acl", (Object)"private");
            this.tryCommit(this.graph, g -> {
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"age"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.property("age").properties(new String[0])));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.property("name").properties(new String[0])));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.property("age").properties(new String[]{"acl"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.property("name").properties(new String[]{"acl"})));
                Assert.assertEquals((Object)"private", v.property("age").values(new String[]{"acl"}).next());
                Assert.assertEquals((Object)"public", v.property("name").values(new String[]{"acl"}).next());
                VertexPropertyProperties.assertVertexEdgeCounts(1, 0);
            });
            v.property("age").property("acl", (Object)"public");
            v.property("age").property("changeDate", (Object)2014);
            this.tryCommit(this.graph, g -> {
                Assert.assertEquals((Object)"public", v.property("age").values(new String[]{"acl"}).next());
                Assert.assertEquals((Object)2014, v.property("age").values(new String[]{"changeDate"}).next());
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"age"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)((VertexProperty)v.properties(new String[]{"age"}).next()).properties(new String[0])));
            });
        }
    }

    @RunWith(value=Parameterized.class)
    @ExceptionCoverage(exceptionClass=Element.Exceptions.class, methods={"elementAlreadyRemoved"})
    public static class ExceptionConsistencyWhenVertexPropertyRemovedTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public Consumer<VertexProperty> functionToTest;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            return Arrays.asList(new Object[][]{{"property(k)", FunctionUtils.wrapConsumer(p -> p.property("year"))}});
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")})
        public void shouldThrowExceptionIfVertexPropertyWasRemoved() {
            Vertex v1 = this.graph.addVertex(new Object[0]);
            VertexProperty p = v1.property(VertexProperty.Cardinality.single, "name", (Object)"stephen", new Object[]{"year", "2012"});
            Object id = p.id();
            p.remove();
            this.tryCommit(this.graph, g -> {
                try {
                    this.functionToTest.accept(p);
                    Assert.fail((String)"Should have thrown exception as the Vertex was already removed");
                }
                catch (Exception ex) {
                    ExceptionConsistencyWhenVertexPropertyRemovedTest.validateException(Element.Exceptions.elementAlreadyRemoved(VertexProperty.class, (Object)id), ex);
                }
            });
        }
    }

    public static class VertexPropertyRemoval
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty")})
        public void shouldSupportIdempotentVertexPropertyRemoval() {
            Vertex a = this.graph.addVertex(new Object[]{"name", "marko"});
            Vertex b = this.graph.addVertex(new Object[]{"name", "daniel", "name", "kuppitz"});
            a.property("name").remove();
            a.property("name").remove();
            a.property("name").remove();
            b.properties(new String[]{"name"}).forEachRemaining(Property::remove);
            b.property("name").remove();
            b.properties(new String[]{"name"}).forEachRemaining(Property::remove);
            b.property("name").remove();
            b.properties(new String[]{"name"}).forEachRemaining(Property::remove);
            b.property("name").remove();
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty")})
        public void shouldAllowIteratingAndRemovingVertexPropertyProperties() {
            Vertex daniel = this.graph.addVertex(new Object[]{"name", "daniel", "name", "kuppitz", "name", "big d", "name", "the german"});
            daniel.properties(new String[]{"name"}).forEachRemaining(vp -> {
                vp.property("aKey", (Object)UUID.randomUUID().toString());
                vp.property("bKey", (Object)UUID.randomUUID().toString());
                vp.property("cKey", (Object)UUID.randomUUID().toString());
            });
            Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)daniel.properties(new String[0])));
            Assert.assertEquals((long)12L, (long)IteratorUtils.list((Iterator)IteratorUtils.map((Iterator)daniel.properties(new String[0]), p -> IteratorUtils.count((Iterator)p.properties(new String[0])))).stream().mapToInt(kv -> kv.intValue()).sum());
            daniel.properties(new String[0]).forEachRemaining(p -> p.properties(new String[0]).forEachRemaining(Property::remove));
            Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)daniel.properties(new String[0])));
            Assert.assertEquals((long)0L, (long)IteratorUtils.list((Iterator)IteratorUtils.map((Iterator)daniel.properties(new String[0]), p -> IteratorUtils.count((Iterator)p.properties(new String[0])))).stream().mapToInt(kv -> kv.intValue()).sum());
            daniel.properties(new String[0]).forEachRemaining(Property::remove);
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)daniel.properties(new String[0])));
            Assert.assertEquals((long)0L, (long)IteratorUtils.list((Iterator)IteratorUtils.map((Iterator)daniel.properties(new String[0]), p -> IteratorUtils.count((Iterator)p.properties(new String[0])))).stream().mapToInt(kv -> kv.intValue()).sum());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty")})
        public void shouldRemoveMultiProperties() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko", "age", 34});
            v.property(VertexProperty.Cardinality.list, "name", (Object)"marko a. rodriguez", new Object[0]);
            this.tryCommit(this.graph);
            v.property(VertexProperty.Cardinality.list, "name", (Object)"marko rodriguez", new Object[0]);
            v.property(VertexProperty.Cardinality.list, "name", (Object)"marko", new Object[0]);
            this.tryCommit(this.graph, graph -> {
                Assert.assertEquals((long)5L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                List values = IteratorUtils.list((Iterator)v.values(new String[]{"name"}));
                Assert.assertThat((Object)values, (Matcher)Matchers.hasItem((Object)"marko a. rodriguez"));
                Assert.assertThat((Object)values, (Matcher)Matchers.hasItem((Object)"marko rodriguez"));
                Assert.assertThat((Object)values, (Matcher)Matchers.hasItem((Object)"marko"));
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
            });
            IteratorUtils.filter((Iterator)v.properties(new String[0]), p -> p.value().equals("marko")).forEachRemaining(Property::remove);
            this.tryCommit(this.graph, graph -> {
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
            });
            v.property("age").remove();
            this.tryCommit(this.graph, graph -> {
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
            });
            IteratorUtils.filter((Iterator)v.properties(new String[]{"name"}), p -> p.key().equals("name")).forEachRemaining(Property::remove);
            this.tryCommit(this.graph, graph -> {
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
            });
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
        public void shouldRemoveMultiPropertiesWhenVerticesAreRemoved() {
            Vertex marko = this.graph.addVertex(new Object[]{"name", "marko", "name", "okram"});
            Vertex stephen = this.graph.addVertex(new Object[]{"name", "stephen", "name", "spmallette"});
            this.tryCommit(this.graph, graph -> {
                VertexPropertyRemoval.assertVertexEdgeCounts(2, 0);
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.properties(new String[]{"name"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)stephen.properties(new String[]{"name"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.properties(new String[0])));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)stephen.properties(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)marko.properties(new String[]{"blah"})));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)stephen.properties(new String[]{"blah"})));
            });
            stephen.remove();
            this.tryCommit(this.graph, graph -> {
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.properties(new String[]{"name"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.properties(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)marko.properties(new String[]{"blah"})));
            });
            for (int i = 0; i < 100; ++i) {
                marko.property(VertexProperty.Cardinality.list, "name", (Object)i, new Object[0]);
            }
            this.tryCommit(this.graph, graph -> {
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
                Assert.assertEquals((long)102L, (long)IteratorUtils.count((Iterator)marko.properties(new String[]{"name"})));
                Assert.assertEquals((long)102L, (long)IteratorUtils.count((Iterator)marko.properties(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)marko.properties(new String[]{"blah"})));
            });
            this.g.V(new Object[0]).properties(new String[]{"name"}).has(T.value, P.test((a, b) -> ((Class)b).isAssignableFrom(a.getClass()), Integer.class)).forEachRemaining(Property::remove);
            this.tryCommit(this.graph, graph -> {
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.properties(new String[]{"name"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.properties(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)marko.properties(new String[]{"blah"})));
            });
            marko.remove();
            this.tryCommit(this.graph, graph -> VertexPropertyRemoval.assertVertexEdgeCounts(0, 0));
        }
    }

    public static class VertexPropertyAddition
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds")})
        public void shouldAllowIdAssignment() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Object id = this.graphProvider.convertId(123131231L, VertexProperty.class);
            v.property(VertexProperty.Cardinality.single, "name", (Object)"stephen", new Object[]{T.id, id});
            this.tryCommit(this.graph, g -> Assert.assertEquals((Object)id, (Object)v.property("name").id()));
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldSetLabelOfVertexPropertyToKeyOfOwningProperty() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "stephen"});
            this.tryCommit(this.graph, g -> Assert.assertEquals((Object)"name", (Object)v.property("name").label()));
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")})
        public void shouldHandleListVertexProperties() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko", "age", 34});
            this.tryCommit(this.graph, g -> {
                Assert.assertEquals((Object)"marko", (Object)v.property("name").value());
                Assert.assertEquals((Object)"marko", (Object)v.value("name"));
                Assert.assertEquals((Object)34, (Object)v.property("age").value());
                Assert.assertEquals((long)34L, (long)((Integer)v.value("age")).intValue());
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                VertexPropertyAddition.assertVertexEdgeCounts(1, 0);
            });
            VertexProperty property = v.property(VertexProperty.Cardinality.list, "name", (Object)"marko a. rodriguez", new Object[0]);
            this.tryCommit(this.graph, g -> Assert.assertEquals((Object)v, (Object)property.element()));
            try {
                v.property("name");
                Assert.fail((String)("This should throw a: " + Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)"name")));
            }
            catch (Exception e) {
                VertexPropertyAddition.validateException(Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)"name"), e);
            }
            Assert.assertTrue((boolean)IteratorUtils.list((Iterator)v.values(new String[]{"name"})).contains("marko"));
            Assert.assertTrue((boolean)IteratorUtils.list((Iterator)v.values(new String[]{"name"})).contains("marko a. rodriguez"));
            Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
            VertexPropertyAddition.assertVertexEdgeCounts(1, 0);
            Assert.assertEquals((Object)v, (Object)v.property(VertexProperty.Cardinality.list, "name", (Object)"mrodriguez", new Object[0]).element());
            this.tryCommit(this.graph, g -> {
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                VertexPropertyAddition.assertVertexEdgeCounts(1, 0);
            });
            v.properties(new String[]{"name"}).forEachRemaining(meta -> meta.property("counter", (Object)((String)meta.value()).length()));
            this.tryCommit(this.graph, g -> {
                v.properties(new String[0]).forEachRemaining(meta -> {
                    Assert.assertEquals((Object)meta.key(), (Object)meta.label());
                    Assert.assertTrue((boolean)meta.isPresent());
                    Assert.assertEquals((Object)v, (Object)meta.element());
                    if (meta.key().equals("age")) {
                        Assert.assertEquals((Object)meta.value(), (Object)34);
                        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)meta.properties(new String[0])));
                    }
                    if (meta.key().equals("name")) {
                        Assert.assertEquals((long)((String)meta.value()).length(), (long)((Integer)meta.value("counter")).intValue());
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)meta.properties(new String[0])));
                        Assert.assertEquals((long)1L, (long)meta.keys().size());
                        Assert.assertTrue((boolean)meta.keys().contains("counter"));
                    }
                });
                VertexPropertyAddition.assertVertexEdgeCounts(1, 0);
            });
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
        public void shouldHandleSingleVertexProperties() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko", "name", "marko a. rodriguez", "name", "marko rodriguez"});
            this.tryCommit(this.graph, g -> {
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                List values = IteratorUtils.list((Iterator)v.values(new String[]{"name"}));
                Assert.assertTrue((boolean)values.contains("marko"));
                Assert.assertTrue((boolean)values.contains("marko a. rodriguez"));
                Assert.assertTrue((boolean)values.contains("marko rodriguez"));
            });
            v.properties(new String[]{"name"}).forEachRemaining(Property::remove);
            this.tryCommit(this.graph, g -> {
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
            });
            v.property(VertexProperty.Cardinality.list, "name", (Object)"marko", new Object[0]);
            v.property(VertexProperty.Cardinality.list, "name", (Object)"marko a. rodriguez", new Object[0]);
            v.property(VertexProperty.Cardinality.list, "name", (Object)"marko rodriguez", new Object[0]);
            this.tryCommit(this.graph, g -> {
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                List values = IteratorUtils.list((Iterator)v.values(new String[]{"name"}));
                Assert.assertTrue((boolean)values.contains("marko"));
                Assert.assertTrue((boolean)values.contains("marko a. rodriguez"));
                Assert.assertTrue((boolean)values.contains("marko rodriguez"));
            });
            v.property(VertexProperty.Cardinality.single, "name", (Object)"okram", new Object[]{"acl", "private", "date", 2014});
            this.tryCommit(this.graph, g -> {
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)((VertexProperty)v.properties(new String[]{"name"}).next()).properties(new String[0])));
                Map valueMap = IteratorUtils.collectMap((Iterator)v.property("name").properties(new String[0]), Property::key, Property::value);
                Assert.assertEquals((Object)"private", valueMap.get("acl"));
                Assert.assertEquals((Object)2014, valueMap.get("date"));
            });
            v.remove();
            this.tryCommit(this.graph, g -> VertexPropertyAddition.assertVertexEdgeCounts(0, 0));
            Vertex u = this.graph.addVertex(new Object[]{"name", "marko", "name", "marko a. rodriguez", "name", "marko rodriguez"});
            this.tryCommit(this.graph);
            u.properties(new String[0]).forEachRemaining(Property::remove);
            u.property(VertexProperty.Cardinality.single, "name", (Object)"okram", new Object[]{"acl", "private", "date", 2014});
            this.tryCommit(this.graph, g -> {
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)u.properties(new String[]{"name"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)u.properties(new String[0])));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)((VertexProperty)u.properties(new String[]{"name"}).next()).properties(new String[0])));
                Map valueMap = IteratorUtils.collectMap((Iterator)u.property("name").properties(new String[0]), Property::key, Property::value);
                Assert.assertEquals((Object)"private", valueMap.get("acl"));
                Assert.assertEquals((Object)2014, valueMap.get("date"));
            });
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
        public void shouldHandleSetVertexProperties() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko", "name", "marko a. rodriguez"});
            this.tryCommit(this.graph, graph -> {
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                List values = IteratorUtils.list((Iterator)v.values(new String[]{"name"}));
                Assert.assertTrue((boolean)values.contains("marko"));
                Assert.assertTrue((boolean)values.contains("marko a. rodriguez"));
            });
            v.property(VertexProperty.Cardinality.set, "name", (Object)"marko rodriguez", new Object[]{"acl", "private"});
            this.tryCommit(this.graph, graph -> {
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                List values = IteratorUtils.list((Iterator)v.values(new String[]{"name"}));
                Assert.assertTrue((boolean)values.contains("marko"));
                Assert.assertTrue((boolean)values.contains("marko a. rodriguez"));
                Assert.assertTrue((boolean)values.contains("marko rodriguez"));
                Iterator iterator = v.properties(new String[]{"name"});
                while (iterator.hasNext()) {
                    VertexProperty property = (VertexProperty)iterator.next();
                    if (((String)property.value()).equals("marko rodriguez")) {
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)property.properties(new String[0])));
                        Assert.assertEquals((Object)"acl", (Object)((Property)property.properties(new String[0]).next()).key());
                        Assert.assertEquals((Object)"private", (Object)((Property)property.properties(new String[0]).next()).value());
                        continue;
                    }
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)property.properties(new String[0])));
                }
            });
            v.property(VertexProperty.Cardinality.set, "name", (Object)"marko rodriguez", new Object[]{"acl", "public", "creator", "stephen"});
            this.tryCommit(this.graph, graph -> {
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[0])));
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.properties(new String[]{"name"})));
                List values = IteratorUtils.list((Iterator)v.values(new String[]{"name"}));
                Assert.assertTrue((boolean)values.contains("marko"));
                Assert.assertTrue((boolean)values.contains("marko a. rodriguez"));
                Assert.assertTrue((boolean)values.contains("marko rodriguez"));
                Iterator iterator = v.properties(new String[]{"name"});
                while (iterator.hasNext()) {
                    VertexProperty property = (VertexProperty)iterator.next();
                    if (((String)property.value()).equals("marko rodriguez")) {
                        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)property.properties(new String[0])));
                        Assert.assertEquals((Object)"acl", (Object)((Property)property.properties(new String[]{"acl"}).next()).key());
                        Assert.assertEquals((Object)"public", (Object)((Property)property.properties(new String[]{"acl"}).next()).value());
                        Assert.assertEquals((Object)"creator", (Object)((Property)property.properties(new String[]{"creator"}).next()).key());
                        Assert.assertEquals((Object)"stephen", (Object)((Property)property.properties(new String[]{"creator"}).next()).value());
                        continue;
                    }
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)property.properties(new String[0])));
                }
            });
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="BooleanValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")})
        public void shouldRespectWhatAreEdgesAndWhatArePropertiesInMultiProperties() {
            Vertex marko = this.graph.addVertex(new Object[]{"name", "marko"});
            Vertex stephen = this.graph.addVertex(new Object[]{"name", "stephen"});
            marko.addEdge("knows", stephen, new Object[0]);
            VertexProperty santaFe = marko.property(VertexProperty.Cardinality.list, "location", (Object)"santa fe", new Object[]{"visible", false});
            VertexProperty newMexico = marko.property(VertexProperty.Cardinality.list, "location", (Object)"new mexico", new Object[]{"visible", true});
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)marko.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)marko.edges(Direction.OUT, new String[]{"knows"})));
            Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)marko.properties(new String[0])));
            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.properties(new String[]{"location"})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)marko.properties(new String[]{"name"})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)stephen.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)stephen.edges(Direction.IN, new String[]{"knows"})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)stephen.properties(new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)stephen.properties(new String[]{"name"})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)santaFe.properties(new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)santaFe.properties(new String[]{"visible"})));
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)santaFe.properties(new String[]{T.key.getAccessor()})));
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)santaFe.properties(new String[]{T.value.getAccessor()})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)newMexico.properties(new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)newMexico.properties(new String[]{"visible"})));
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)newMexico.properties(new String[]{T.key.getAccessor()})));
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)newMexico.properties(new String[]{T.value.getAccessor()})));
        }
    }

    public static class BasicVertexProperty
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")})
        public void shouldValidateEquality() {
            Vertex v = this.graph.addVertex(new Object[0]);
            VertexProperty vp1 = v.property(VertexProperty.Cardinality.single, "x", (Object)0, new Object[0]);
            VertexProperty vp2 = v.property(VertexProperty.Cardinality.single, "y", (Object)1, new Object[0]);
            Assert.assertEquals((Object)vp1, (Object)vp1);
            Assert.assertEquals((Object)vp2, (Object)vp2);
            Assert.assertNotEquals((Object)vp1, (Object)vp2);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")})
        public void shouldValidateIdEquality() {
            Vertex v = this.graph.addVertex(new Object[0]);
            VertexProperty vp1 = v.property(VertexProperty.Cardinality.single, "x", (Object)0, new Object[0]);
            VertexProperty vp2 = v.property(VertexProperty.Cardinality.single, "y", (Object)1, new Object[0]);
            Assert.assertEquals((Object)vp1.id(), (Object)vp1.id());
            Assert.assertEquals((Object)vp2.id(), (Object)vp2.id());
            Assert.assertEquals((Object)vp1.id().toString(), (Object)vp1.id().toString());
            Assert.assertEquals((Object)vp2.id().toString(), (Object)vp2.id().toString());
            Assert.assertNotEquals((Object)vp1.id(), (Object)vp2.id());
            Assert.assertNotEquals((Object)vp1.id().toString(), (Object)vp2.id().toString());
        }
    }
}

