/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IoPropertyTest
extends AbstractGremlinTest {
    @Parameterized.Parameter(value=0)
    public String ioType;
    @Parameterized.Parameter(value=1)
    public boolean assertIdDirectly;
    @Parameterized.Parameter(value=2)
    public boolean assertDouble;
    @Parameterized.Parameter(value=3)
    public Function<Graph, GraphReader> readerMaker;
    @Parameterized.Parameter(value=4)
    public Function<Graph, GraphWriter> writerMaker;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"graphson", false, false, g -> ((GraphSONIo)g.io(IoCore.graphson())).reader().create(), g -> ((GraphSONIo)g.io(IoCore.graphson())).writer().create()}, {"graphson-embedded", true, true, g -> ((GraphSONIo)g.io(IoCore.graphson())).reader().mapper(((GraphSONIo)g.io(IoCore.graphson())).mapper().embedTypes(true).create()).create(), g -> ((GraphSONIo)g.io(IoCore.graphson())).writer().mapper(((GraphSONIo)g.io(IoCore.graphson())).mapper().embedTypes(true).create()).create()}, {"gryo", true, true, g -> ((GryoIo)g.io(IoCore.gryo())).reader().create(), g -> ((GryoIo)g.io(IoCore.gryo())).writer().create()});
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldReadWriteVertexPropertyWithMetaProperties() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            VertexProperty p = (VertexProperty)this.g.V(new Object[]{this.convertToVertexId("marko")}).properties(new String[]{"location"}).as("p", new String[0]).has("endTime").select("p").next();
            writer.writeVertexProperty((OutputStream)os, p);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertexProperty((InputStream)bais, propertyAttachable -> {
                    Assert.assertEquals((Object)p.value(), (Object)((VertexProperty)propertyAttachable.get()).value());
                    Assert.assertEquals((Object)p.key(), (Object)((VertexProperty)propertyAttachable.get()).key());
                    Assert.assertEquals((long)IteratorUtils.count((Iterator)p.properties(new String[0])), (long)IteratorUtils.count((Iterator)((VertexProperty)propertyAttachable.get()).properties(new String[0])));
                    Assert.assertEquals((Object)p.property("startTime").value(), (Object)((Property)((VertexProperty)propertyAttachable.get()).properties(new String[]{"startTime"}).next()).value());
                    Assert.assertEquals((Object)p.property("endTime").value(), (Object)((Property)((VertexProperty)propertyAttachable.get()).properties(new String[]{"endTime"}).next()).value());
                    called.set(true);
                    return (VertexProperty)propertyAttachable.get();
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldReadWriteVertexPropertyNoMetaProperties() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            VertexProperty p = ((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).property("name");
            writer.writeVertexProperty((OutputStream)os, p);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readVertexProperty((InputStream)bais, propertyAttachable -> {
                    Assert.assertEquals((Object)p.value(), (Object)((VertexProperty)propertyAttachable.get()).value());
                    Assert.assertEquals((Object)p.key(), (Object)((VertexProperty)propertyAttachable.get()).key());
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)((VertexProperty)propertyAttachable.get()).properties(new String[0])));
                    called.set(true);
                    return (VertexProperty)propertyAttachable.get();
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldReadWritePropertyGraphSON() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.writerMaker.apply(this.graph);
            Property p = ((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()).property("weight");
            writer.writeProperty((OutputStream)os, p);
            AtomicBoolean called = new AtomicBoolean(false);
            GraphReader reader = this.readerMaker.apply(this.graph);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readProperty((InputStream)bais, propertyAttachable -> {
                    Assert.assertEquals((Object)p.value(), (Object)((Property)propertyAttachable.get()).value());
                    Assert.assertEquals((Object)p.key(), (Object)((Property)propertyAttachable.get()).key());
                    called.set(true);
                    return (Property)propertyAttachable.get();
                });
            }
            Assert.assertTrue((boolean)called.get());
        }
    }
}

