/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.ExceptionCoverageSet;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.PropertyTest;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.VariablesTest;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Enclosed.class)
public class FeatureSupportTest {
    private static final String INVALID_FEATURE_SPECIFICATION = "Features for %s specify that %s is false, but the feature appears to be implemented.  Reconsider this setting or throw the standard Exception.";
    private static final Logger logger = LoggerFactory.getLogger(FeatureSupportTest.class);

    public static class LogicalFeatureSupportTest
    extends AbstractGremlinTest {
        private Graph.Features.EdgeFeatures edgeFeatures;
        private Graph.Features.EdgePropertyFeatures edgePropertyFeatures;
        private Graph.Features.GraphFeatures graphFeatures;
        private Graph.Features.VariableFeatures variablesFeatures;
        private Graph.Features.VertexFeatures vertexFeatures;
        private Graph.Features.VertexPropertyFeatures vertexPropertyFeatures;

        @Before
        public void innerSetup() {
            Graph.Features f = this.graph.features();
            this.edgeFeatures = f.edge();
            this.edgePropertyFeatures = this.edgeFeatures.properties();
            this.graphFeatures = f.graph();
            this.variablesFeatures = this.graphFeatures.variables();
            this.vertexFeatures = f.vertex();
            this.vertexPropertyFeatures = this.vertexFeatures.properties();
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds")
        public void shouldNotSupportAnyIdsUnlessUserSuppliedIdsIsSupportedOnVertex() {
            Assert.assertTrue((boolean)this.vertexFeatures.supportsUserSuppliedIds());
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AnyIds")
        public void shouldNotSupportAnyIdsUnlessUserSuppliedIdsIsSupportedOnEdge() {
            Assert.assertTrue((boolean)this.edgeFeatures.supportsUserSuppliedIds());
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="AnyIds")
        public void shouldNotSupportAnyIdsUnlessUserSuppliedIdsIsSupportedOnVertexProperty() {
            Assert.assertTrue((boolean)this.vertexPropertyFeatures.supportsUserSuppliedIds());
        }

        @Test
        public void shouldSupportADataTypeIfGraphHasVariablesEnabled() {
            Assert.assertEquals((Object)this.variablesFeatures.supportsVariables(), (Object)(this.variablesFeatures.supportsBooleanValues() || this.variablesFeatures.supportsDoubleValues() || this.variablesFeatures.supportsFloatValues() || this.variablesFeatures.supportsIntegerValues() || this.variablesFeatures.supportsLongValues() || this.variablesFeatures.supportsMapValues() || this.variablesFeatures.supportsMixedListValues() || this.variablesFeatures.supportsByteValues() || this.variablesFeatures.supportsBooleanArrayValues() || this.variablesFeatures.supportsByteArrayValues() || this.variablesFeatures.supportsDoubleArrayValues() || this.variablesFeatures.supportsFloatArrayValues() || this.variablesFeatures.supportsIntegerArrayValues() || this.variablesFeatures.supportsLongArrayValues() || this.variablesFeatures.supportsSerializableValues() || this.variablesFeatures.supportsStringValues() || this.variablesFeatures.supportsUniformListValues() || this.variablesFeatures.supportsStringArrayValues() ? 1 : 0));
        }

        @Test
        public void shouldSupportADataTypeIfEdgeHasPropertyEnabled() {
            Assert.assertEquals((Object)this.edgePropertyFeatures.supportsProperties(), (Object)(this.edgePropertyFeatures.supportsBooleanValues() || this.edgePropertyFeatures.supportsDoubleValues() || this.edgePropertyFeatures.supportsFloatValues() || this.edgePropertyFeatures.supportsIntegerValues() || this.edgePropertyFeatures.supportsLongValues() || this.edgePropertyFeatures.supportsMapValues() || this.edgePropertyFeatures.supportsMixedListValues() || this.edgePropertyFeatures.supportsByteValues() || this.edgePropertyFeatures.supportsBooleanArrayValues() || this.edgePropertyFeatures.supportsByteArrayValues() || this.edgePropertyFeatures.supportsDoubleArrayValues() || this.edgePropertyFeatures.supportsFloatArrayValues() || this.edgePropertyFeatures.supportsIntegerArrayValues() || this.edgePropertyFeatures.supportsLongArrayValues() || this.edgePropertyFeatures.supportsSerializableValues() || this.edgePropertyFeatures.supportsStringValues() || this.edgePropertyFeatures.supportsUniformListValues() || this.edgePropertyFeatures.supportsStringArrayValues() ? 1 : 0));
        }

        @Test
        public void shouldSupportADataTypeIfVertexHasPropertyEnabled() {
            Assert.assertEquals((Object)this.vertexPropertyFeatures.supportsProperties(), (Object)(this.vertexPropertyFeatures.supportsBooleanValues() || this.vertexPropertyFeatures.supportsDoubleValues() || this.vertexPropertyFeatures.supportsFloatValues() || this.vertexPropertyFeatures.supportsIntegerValues() || this.vertexPropertyFeatures.supportsLongValues() || this.vertexPropertyFeatures.supportsMapValues() || this.vertexPropertyFeatures.supportsMixedListValues() || this.vertexPropertyFeatures.supportsByteValues() || this.vertexPropertyFeatures.supportsBooleanArrayValues() || this.vertexPropertyFeatures.supportsByteArrayValues() || this.vertexPropertyFeatures.supportsDoubleArrayValues() || this.vertexPropertyFeatures.supportsFloatArrayValues() || this.vertexPropertyFeatures.supportsIntegerArrayValues() || this.vertexPropertyFeatures.supportsLongArrayValues() || this.vertexPropertyFeatures.supportsSerializableValues() || this.vertexPropertyFeatures.supportsStringValues() || this.vertexPropertyFeatures.supportsUniformListValues() || this.vertexPropertyFeatures.supportsStringArrayValues() ? 1 : 0));
        }

        @Test
        public void shouldSupportRegularTransactionsIfThreadedTransactionsAreEnabled() {
            if (this.graphFeatures.supportsThreadedTransactions()) {
                Assert.assertTrue((boolean)this.graphFeatures.supportsThreadedTransactions());
            }
        }
    }

    @ExceptionCoverageSet(value={@ExceptionCoverage(exceptionClass=VertexProperty.Exceptions.class, methods={"multiPropertiesNotSupported", "metaPropertiesNotSupported", "userSuppliedIdsNotSupported", "userSuppliedIdsOfThisTypeNotSupported"}), @ExceptionCoverage(exceptionClass=Element.Exceptions.class, methods={"propertyRemovalNotSupported"})})
    public static class VertexPropertyFunctionalityTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds", supported=false)
        public void shouldSupportUserSuppliedIdsIfAnIdCanBeAssigned() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.property(VertexProperty.Cardinality.single, "name", (Object)"me", new Object[]{T.id, this.graphProvider.convertId(99999943835L, VertexProperty.class)});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "UserSuppliedIds"));
            }
            catch (Exception ex) {
                VertexPropertyFunctionalityTest.validateException(VertexProperty.Exceptions.userSuppliedIdsNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds", supported=false)
        public void shouldNotAllowAnyIdsIfUserSuppliedIdsIsFalse() throws Exception {
            Assert.assertFalse((boolean)this.graph.features().vertex().properties().willAllowId(this.graphProvider.convertId(99999943835L, VertexProperty.class)));
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeString() throws Exception {
            String id = "this-is-a-valid-id";
            Assume.assumeFalse((boolean)this.graph.features().vertex().properties().willAllowId((Object)"this-is-a-valid-id"));
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.property(VertexProperty.Cardinality.single, "test", (Object)v, new Object[]{T.id, "this-is-a-valid-id"});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexPropertyFeatures.class.getSimpleName(), "StringIds"));
            }
            catch (Exception ex) {
                VertexPropertyFunctionalityTest.validateException(VertexProperty.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="NumericIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeNumericInt() throws Exception {
            int id = 123456;
            Assume.assumeFalse((boolean)this.graph.features().vertex().properties().willAllowId((Object)123456));
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.property(VertexProperty.Cardinality.single, "test", (Object)v, new Object[]{T.id, 123456});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexPropertyFeatures.class.getSimpleName(), "NumericIds"));
            }
            catch (Exception ex) {
                VertexPropertyFunctionalityTest.validateException(VertexProperty.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="NumericIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeNumericLong() throws Exception {
            long id = 123456L;
            Assume.assumeFalse((boolean)this.graph.features().vertex().properties().willAllowId((Object)123456L));
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.property(VertexProperty.Cardinality.single, "test", (Object)v, new Object[]{T.id, 123456L});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexPropertyFeatures.class.getSimpleName(), "NumericIds"));
            }
            catch (Exception ex) {
                VertexPropertyFunctionalityTest.validateException(VertexProperty.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UuidIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeUuid() throws Exception {
            UUID id = UUID.randomUUID();
            Assume.assumeFalse((boolean)this.graph.features().vertex().properties().willAllowId((Object)id));
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.property(VertexProperty.Cardinality.single, "test", (Object)v, new Object[]{T.id, id});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexPropertyFeatures.class.getSimpleName(), "UuidIds"));
            }
            catch (Exception ex) {
                VertexPropertyFunctionalityTest.validateException(VertexProperty.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="AnyIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeAny() throws Exception {
            Date id = new Date();
            Assume.assumeFalse((boolean)this.graph.features().vertex().properties().willAllowId((Object)id));
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.property(VertexProperty.Cardinality.single, "test", (Object)v, new Object[]{T.id, id});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexPropertyFeatures.class.getSimpleName(), "AnyIds"));
            }
            catch (Exception ex) {
                VertexPropertyFunctionalityTest.validateException(VertexProperty.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringIds", supported=false)})
        public void shouldSupportStringIdsIfStringIdsAreGeneratedFromTheGraph() throws Exception {
            Vertex v = this.graph.addVertex(new Object[0]);
            VertexProperty p = v.property(VertexProperty.Cardinality.single, "name", (Object)"stephen", new Object[0]);
            if (p.id() instanceof String) {
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexPropertyFeatures.class.getSimpleName(), "StringIds"));
            }
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UuidIds", supported=false)})
        public void shouldSupportUuidIdsIfUuidIdsAreGeneratedFromTheGraph() throws Exception {
            Vertex v = this.graph.addVertex(new Object[0]);
            VertexProperty p = v.property(VertexProperty.Cardinality.single, "name", (Object)"stephen", new Object[0]);
            if (p.id() instanceof UUID) {
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexPropertyFeatures.class.getSimpleName(), "UuidIds"));
            }
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="NumericIds", supported=false)})
        public void shouldSupportNumericIdsIfNumericIdsAreGeneratedFromTheGraph() throws Exception {
            Vertex v = this.graph.addVertex(new Object[0]);
            VertexProperty p = v.property(VertexProperty.Cardinality.single, "name", (Object)"stephen", new Object[0]);
            if (p.id() instanceof Number) {
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexPropertyFeatures.class.getSimpleName(), "NumericIds"));
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="RemoveProperty", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")})
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldSupportRemovePropertyIfAPropertyCanBeRemoved() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                VertexProperty p = v.property(VertexProperty.Cardinality.single, "name", (Object)"me", new Object[]{"test", "this"});
                p.property("test").remove();
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexPropertyFeatures.class.getSimpleName(), "RemoveProperty"));
            }
            catch (Exception ex) {
                VertexPropertyFunctionalityTest.validateException(Property.Exceptions.propertyRemovalNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties", supported=false)})
        public void shouldSupportMultiPropertyIfTheSameKeyCanBeAssignedMoreThanOnce() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[]{"name", "stephen", "name", "steve"});
                if (2L == IteratorUtils.count((Iterator)v.properties(new String[0]))) {
                    Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "MultiProperties"));
                }
            }
            catch (Exception ex) {
                VertexPropertyFunctionalityTest.validateException(VertexProperty.Exceptions.multiPropertiesNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")})
        public void shouldSupportMetaPropertyIfPropertiesCanBePutOnProperties() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.property(VertexProperty.Cardinality.single, "name", (Object)"stephen", new Object[]{"p", "on-property"});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "MetaProperties"));
            }
            catch (Exception ex) {
                VertexPropertyFunctionalityTest.validateException(VertexProperty.Exceptions.metaPropertiesNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")})
        public void shouldSupportMetaPropertyIfPropertiesCanBePutOnPropertiesViaVertexProperty() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[]{"name", "stephen"});
                v.property("name").property("p", (Object)"on-property");
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "MetaProperties"));
            }
            catch (Exception ex) {
                VertexPropertyFunctionalityTest.validateException(VertexProperty.Exceptions.metaPropertiesNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")})
        public void shouldSupportMetaPropertyIfPropertiesHaveAnIteratorViaVertexProperty() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[]{"name", "stephen"});
                v.property("name").properties(new String[0]);
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "MetaProperties"));
            }
            catch (Exception ex) {
                VertexPropertyFunctionalityTest.validateException(VertexProperty.Exceptions.metaPropertiesNotSupported(), ex);
            }
        }
    }

    @RunWith(value=Parameterized.class)
    @ExceptionCoverage(exceptionClass=Graph.Variables.Exceptions.class, methods={"dataTypeOfVariableValueNotSupported"})
    public static class GraphVariablesFunctionalityTest
    extends AbstractGremlinTest {
        private static final String INVALID_FEATURE_SPECIFICATION = "Features for %s specify that %s is false, but the feature appears to be implemented.  Reconsider this setting or throw the standard Exception.";
        @Parameterized.Parameter(value=0)
        public String featureName;
        @Parameterized.Parameter(value=1)
        public Object value;

        @Parameterized.Parameters(name="supports{0}({1})")
        public static Iterable<Object[]> data() {
            return VariablesTest.GraphVariablesFeatureSupportTest.data();
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables")
        public void shouldEnableFeatureOnGraphIfNotEnabled() throws Exception {
            Assume.assumeThat((Object)this.graph.features().supports(Graph.Features.VariableFeatures.class, this.featureName), (Matcher)CoreMatchers.is((Object)false));
            try {
                Graph.Variables variables = this.graph.variables();
                variables.set("aKey", this.value);
                Assert.fail((String)String.format("Features for %s specify that %s is false, but the feature appears to be implemented.  Reconsider this setting or throw the standard Exception.", Graph.Features.VariableFeatures.class.getSimpleName(), this.featureName));
            }
            catch (Exception e) {
                GraphVariablesFunctionalityTest.validateException(Graph.Variables.Exceptions.dataTypeOfVariableValueNotSupported((Object)this.value), e);
            }
        }
    }

    @RunWith(value=Parameterized.class)
    @ExceptionCoverage(exceptionClass=Property.Exceptions.class, methods={"dataTypeOfPropertyValueNotSupported"})
    public static class ElementPropertyDataTypeFunctionalityTest
    extends AbstractGremlinTest {
        private static final String INVALID_FEATURE_SPECIFICATION = "Features for %s specify that %s is false, but the feature appears to be implemented.  Reconsider this setting or throw the standard Exception.";
        @Parameterized.Parameter(value=0)
        public String featureName;
        @Parameterized.Parameter(value=1)
        public Object value;

        @Parameterized.Parameters(name="supports{0}({1})")
        public static Iterable<Object[]> data() {
            return PropertyTest.PropertyFeatureSupportTest.data();
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty")})
        public void shouldEnableFeatureOnEdgeIfNotEnabled() throws Exception {
            Assume.assumeThat((Object)this.graph.features().supports(Graph.Features.EdgePropertyFeatures.class, this.featureName), (Matcher)CoreMatchers.is((Object)false));
            try {
                Edge edge = this.createEdgeForPropertyFeatureTests();
                edge.property("aKey", this.value);
                Assert.fail((String)String.format("Features for %s specify that %s is false, but the feature appears to be implemented.  Reconsider this setting or throw the standard Exception.", Graph.Features.EdgePropertyFeatures.class.getSimpleName(), this.featureName));
            }
            catch (Exception e) {
                ElementPropertyDataTypeFunctionalityTest.validateException(Property.Exceptions.dataTypeOfPropertyValueNotSupported((Object)this.value), e);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
        public void shouldEnableFeatureOnVertexIfNotEnabled() throws Exception {
            Assume.assumeThat((Object)this.graph.features().supports(Graph.Features.VertexPropertyFeatures.class, this.featureName), (Matcher)CoreMatchers.is((Object)false));
            try {
                this.graph.addVertex(new Object[]{"aKey", this.value});
                Assert.fail((String)String.format("Features for %s specify that %s is false, but the feature appears to be implemented.  Reconsider this setting or throw the standard Exception.", Graph.Features.VertexPropertyFeatures.class.getSimpleName(), this.featureName));
            }
            catch (Exception e) {
                ElementPropertyDataTypeFunctionalityTest.validateException(Property.Exceptions.dataTypeOfPropertyValueNotSupported((Object)this.value), e);
            }
        }

        private Edge createEdgeForPropertyFeatureTests() {
            Vertex vertexA = this.graph.addVertex(new Object[0]);
            Vertex vertexB = this.graph.addVertex(new Object[0]);
            return vertexA.addEdge(this.graphProvider.convertLabel("knows"), vertexB, new Object[0]);
        }
    }

    @ExceptionCoverageSet(value={@ExceptionCoverage(exceptionClass=Vertex.Exceptions.class, methods={"edgeAdditionsNotSupported"}), @ExceptionCoverage(exceptionClass=Edge.Exceptions.class, methods={"edgeRemovalNotSupported", "userSuppliedIdsNotSupported", "userSuppliedIdsOfThisTypeNotSupported"}), @ExceptionCoverage(exceptionClass=Element.Exceptions.class, methods={"propertyAdditionNotSupported"}), @ExceptionCoverage(exceptionClass=Property.Exceptions.class, methods={"propertyRemovalNotSupported"})})
    public static class EdgeFunctionalityTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldSupportAddEdgesIfEdgeCanBeAdded() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("friend", v, new Object[0]);
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "AddEdges"));
            }
            catch (Exception e) {
                EdgeFunctionalityTest.validateException(Vertex.Exceptions.edgeAdditionsNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds", supported=false)})
        public void shouldSupportUserSuppliedIdsIfAnIdCanBeAssignedToEdge() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("friend", v, new Object[]{T.id, this.graphProvider.convertId(99999943835L, Edge.class)});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "UserSuppliedIds"));
            }
            catch (Exception e) {
                EdgeFunctionalityTest.validateException(Edge.Exceptions.userSuppliedIdsNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds", supported=false)
        public void shouldNotAllowAnyIdsIfUserSuppliedIdsIsFalse() throws Exception {
            Assert.assertFalse((boolean)this.graph.features().edge().willAllowId(this.graphProvider.convertId(99999943835L, Edge.class)));
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds", supported=false), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="StringIds", supported=false)})
        public void shouldSupportStringIdsIfStringIdsAreGeneratedFromTheGraph() throws Exception {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("knows", v, new Object[0]);
            if (e.id() instanceof String) {
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.EdgeFeatures.class.getSimpleName(), "StringIds"));
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds", supported=false), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UuidIds", supported=false)})
        public void shouldSupportUuidIdsIfUuidIdsAreGeneratedFromTheGraph() throws Exception {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("knows", v, new Object[0]);
            if (e.id() instanceof UUID) {
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.EdgeFeatures.class.getSimpleName(), "UuidIds"));
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds", supported=false), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="NumericIds", supported=false)})
        public void shouldSupportNumericIdsIfNumericIdsAreGeneratedFromTheGraph() throws Exception {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("knows", v, new Object[0]);
            if (e.id() instanceof Number) {
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.EdgeFeatures.class.getSimpleName(), "NumericIds"));
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeString() throws Exception {
            String id = "this-is-a-valid-id";
            Assume.assumeFalse((boolean)this.graph.features().edge().willAllowId((Object)"this-is-a-valid-id"));
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("test", v, new Object[]{T.id, "this-is-a-valid-id"});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.EdgeFeatures.class.getSimpleName(), "StringIds"));
            }
            catch (Exception e) {
                EdgeFunctionalityTest.validateException(Edge.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeNumericInt() throws Exception {
            int id = 123456;
            Assume.assumeFalse((boolean)this.graph.features().edge().willAllowId((Object)123456));
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("test", v, new Object[]{T.id, 123456});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.EdgeFeatures.class.getSimpleName(), "NumericIds"));
            }
            catch (Exception e) {
                EdgeFunctionalityTest.validateException(Edge.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeNumericLong() throws Exception {
            long id = 123456L;
            Assume.assumeFalse((boolean)this.graph.features().edge().willAllowId((Object)123456L));
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("test", v, new Object[]{T.id, 123456L});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.EdgeFeatures.class.getSimpleName(), "NumericIds"));
            }
            catch (Exception e) {
                EdgeFunctionalityTest.validateException(Edge.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeUuid() throws Exception {
            UUID id = UUID.randomUUID();
            Assume.assumeFalse((boolean)this.graph.features().edge().willAllowId((Object)id));
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("test", v, new Object[]{T.id, id});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.EdgeFeatures.class.getSimpleName(), "UuidIds"));
            }
            catch (Exception e) {
                EdgeFunctionalityTest.validateException(Edge.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeAny() throws Exception {
            Date id = new Date();
            Assume.assumeFalse((boolean)this.graph.features().edge().willAllowId((Object)id));
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("test", v, new Object[]{T.id, id});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.EdgeFeatures.class.getSimpleName(), "AnyIds"));
            }
            catch (Exception e) {
                EdgeFunctionalityTest.validateException(Edge.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty", supported=false)})
        public void shouldSupportAddEdgePropertyIfItCanBeAdded() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                Edge e = v.addEdge("test", v, new Object[0]);
                e.property("should", (Object)"not-add-property");
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.EdgePropertyFeatures.class.getSimpleName(), "AddProperty"));
            }
            catch (Exception e) {
                EdgeFunctionalityTest.validateException(Element.Exceptions.propertyAdditionNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveEdges", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldSupportRemoveEdgesIfEdgeCanBeRemoved() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("friend", v, new Object[0]);
                v.remove();
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "RemoveEdges"));
            }
            catch (Exception ex) {
                EdgeFunctionalityTest.validateException(Edge.Exceptions.edgeRemovalNotSupported(), ex);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveProperty", supported=false)
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldSupportRemovePropertyIfAPropertyCanBeRemoved() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                Edge e = v.addEdge("self", v, new Object[0]);
                e.property("name").remove();
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.EdgeFeatures.class.getSimpleName(), "RemoveProperty"));
            }
            catch (Exception ex) {
                EdgeFunctionalityTest.validateException(Property.Exceptions.propertyRemovalNotSupported(), ex);
            }
        }
    }

    @ExceptionCoverageSet(value={@ExceptionCoverage(exceptionClass=Vertex.Exceptions.class, methods={"userSuppliedIdsNotSupported", "userSuppliedIdsOfThisTypeNotSupported", "vertexRemovalNotSupported"}), @ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"vertexAdditionsNotSupported"}), @ExceptionCoverage(exceptionClass=Element.Exceptions.class, methods={"propertyAdditionNotSupported"}), @ExceptionCoverage(exceptionClass=Property.Exceptions.class, methods={"propertyRemovalNotSupported"})})
    public static class VertexFunctionalityTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices", supported=false)
        public void shouldSupportAddVerticesIfAVertexCanBeAdded() throws Exception {
            try {
                this.graph.addVertex(new Object[0]);
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "AddVertices"));
            }
            catch (Exception e) {
                VertexFunctionalityTest.validateException(Graph.Exceptions.vertexAdditionsNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds", supported=false)})
        public void shouldSupportUserSuppliedIdsIfAnIdCanBeAssignedToVertex() throws Exception {
            try {
                this.graph.addVertex(new Object[]{T.id, this.graphProvider.convertId(99999943835L, Vertex.class)});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "UserSuppliedIds"));
            }
            catch (Exception e) {
                VertexFunctionalityTest.validateException(Vertex.Exceptions.userSuppliedIdsNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds", supported=false)
        public void shouldNotAllowAnyIdsIfUserSuppliedIdsIsFalse() throws Exception {
            Assert.assertFalse((boolean)this.graph.features().vertex().willAllowId(this.graphProvider.convertId(99999943835L, Vertex.class)));
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeString() throws Exception {
            String id = "this-is-a-valid-id";
            Assume.assumeFalse((boolean)this.graph.features().vertex().willAllowId((Object)"this-is-a-valid-id"));
            try {
                this.graph.addVertex(new Object[]{T.id, "this-is-a-valid-id"});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "StringIds"));
            }
            catch (Exception e) {
                VertexFunctionalityTest.validateException(Vertex.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeNumericInt() throws Exception {
            int id = 123456;
            Assume.assumeFalse((boolean)this.graph.features().vertex().willAllowId((Object)123456));
            try {
                this.graph.addVertex(new Object[]{T.id, 123456});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "NumericIds"));
            }
            catch (Exception e) {
                VertexFunctionalityTest.validateException(Vertex.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeNumericLong() throws Exception {
            long id = 123456L;
            Assume.assumeFalse((boolean)this.graph.features().vertex().willAllowId((Object)123456L));
            try {
                this.graph.addVertex(new Object[]{T.id, 123456L});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "NumericIds"));
            }
            catch (Exception e) {
                VertexFunctionalityTest.validateException(Vertex.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeUuid() throws Exception {
            UUID id = UUID.randomUUID();
            Assume.assumeFalse((boolean)this.graph.features().vertex().willAllowId((Object)id));
            try {
                this.graph.addVertex(new Object[]{T.id, id});
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "UuidIds"));
            }
            catch (Exception e) {
                VertexFunctionalityTest.validateException(Vertex.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds", supported=false)})
        public void shouldSupportUserSuppliedIdsOfTypeAny() throws Exception {
            try {
                Date id = new Date();
                this.graph.addVertex(new Object[]{T.id, id});
                if (!this.graph.features().vertex().willAllowId((Object)id)) {
                    Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "AnyIds"));
                }
            }
            catch (Exception e) {
                VertexFunctionalityTest.validateException(Vertex.Exceptions.userSuppliedIdsOfThisTypeNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds", supported=false)})
        public void shouldSupportStringIdsIfStringIdsAreGeneratedFromTheGraph() throws Exception {
            Vertex v = this.graph.addVertex(new Object[0]);
            if (v.id() instanceof String) {
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "StringIds"));
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds", supported=false)})
        public void shouldSupportUuidIdsIfUuidIdsAreGeneratedFromTheGraph() throws Exception {
            Vertex v = this.graph.addVertex(new Object[0]);
            if (v.id() instanceof UUID) {
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "UuidIds"));
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds", supported=false)})
        public void shouldSupportNumericIdsIfNumericIdsAreGeneratedFromTheGraph() throws Exception {
            Vertex v = this.graph.addVertex(new Object[0]);
            if (v.id() instanceof Number) {
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "NumericIds"));
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty", supported=false)})
        public void shouldSupportAddVertexPropertyIfItCanBeAdded() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.property(VertexProperty.Cardinality.single, "should", (Object)"not-add-property", new Object[0]);
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "AddProperty"));
            }
            catch (Exception e) {
                VertexFunctionalityTest.validateException(Element.Exceptions.propertyAdditionNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices", supported=false), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldSupportRemoveVerticesIfAVertexCanBeRemoved() throws Exception {
            try {
                this.graph.addVertex(new Object[0]).remove();
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "RemoveVertices"));
            }
            catch (Exception e) {
                VertexFunctionalityTest.validateException(Vertex.Exceptions.vertexRemovalNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty", supported=false)
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldSupportRemovePropertyIfAPropertyCanBeRemoved() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[]{"name", "me"});
                v.property("name").remove();
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VertexFeatures.class.getSimpleName(), "RemoveProperty"));
            }
            catch (Exception e) {
                VertexFunctionalityTest.validateException(Property.Exceptions.propertyRemovalNotSupported(), e);
            }
        }
    }

    @ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"variablesNotSupported", "graphComputerNotSupported", "transactionsNotSupported"})
    public static class GraphFunctionalityTest
    extends AbstractGremlinTest {
        @Test
        public void shouldPrintTheFeatureList() {
            logger.info(String.format("Printing Features of %s for reference: ", this.g.getClass().getSimpleName()));
            logger.info(this.graph.features().toString());
            Assert.assertTrue((boolean)true);
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Computer", supported=false)
        public void shouldSupportComputerIfAGraphCanCompute() throws Exception {
            try {
                this.graph.compute();
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.GraphFeatures.class.getSimpleName(), "Computer"));
            }
            catch (Exception e) {
                GraphFunctionalityTest.validateException(Graph.Exceptions.graphComputerNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions", supported=false)
        public void shouldSupportTransactionsIfAGraphConstructsATx() throws Exception {
            try {
                this.graph.tx();
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.GraphFeatures.class.getSimpleName(), "Transactions"));
            }
            catch (Exception e) {
                GraphFunctionalityTest.validateException(Graph.Exceptions.transactionsNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables", supported=false)
        public void shouldSupportMemoryIfAGraphAcceptsMemory() throws Exception {
            try {
                this.graph.variables();
                Assert.fail((String)String.format(FeatureSupportTest.INVALID_FEATURE_SPECIFICATION, Graph.Features.VariableFeatures.class.getSimpleName(), "Variables"));
            }
            catch (Exception e) {
                GraphFunctionalityTest.validateException(Graph.Exceptions.variablesNotSupported(), e);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="ThreadedTransactions", supported=false)})
        public void shouldThrowOnThreadedTransactionNotSupported() {
            try {
                this.graph.tx().createThreadedTx();
                Assert.fail((String)"An exception should be thrown since the threaded transaction feature is not supported");
            }
            catch (Exception e) {
                GraphFunctionalityTest.validateException(Transaction.Exceptions.threadedTransactionsNotSupported(), e);
            }
        }
    }

    public static class FeatureToStringTest
    extends AbstractGremlinTest {
        @Test
        public void shouldHaveStandardToStringRepresentation() {
            Assert.assertTrue((boolean)this.graph.features().toString().startsWith("FEATURES"));
        }
    }
}

