/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.ProgramPhase;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank.PageRankVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.MemoryTraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.EmptyTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMatrix;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;

public abstract class ProgramTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Vertex> get_g_V_programXpageRankX();

    public abstract Traversal<Vertex, Map<String, List<Object>>> get_g_V_hasLabelXpersonX_programXpageRank_rankX_order_byXrank_incrX_valueMapXname_rankX();

    public abstract Traversal<Vertex, Map<String, Object>> get_g_V_outXcreatedX_aggregateXxX_byXlangX_groupCount_programXTestProgramX_asXaX_selectXa_xX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_programXpageRankX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_programXpageRankX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Vertex vertex = (Vertex)traversal.next();
            ++counter;
            Assert.assertTrue((boolean)vertex.property("gremlin.pageRankVertexProgram.pageRank").isPresent());
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_programXpageRank_rankX_order_byXrank_decrX_valueMapXname_rankX() {
        Traversal<Vertex, Map<String, List<Object>>> traversal = this.get_g_V_hasLabelXpersonX_programXpageRank_rankX_order_byXrank_incrX_valueMapXname_rankX();
        this.printTraversalForm(traversal);
        int counter = 0;
        double lastRank = Double.MIN_VALUE;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)map.size());
            Assert.assertEquals((long)1L, (long)((List)map.get("name")).size());
            Assert.assertEquals((long)1L, (long)((List)map.get("rank")).size());
            String name = (String)((List)map.get("name")).get(0);
            double rank = (Double)((List)map.get("rank")).get(0);
            Assert.assertTrue((rank >= lastRank ? 1 : 0) != 0);
            lastRank = rank;
            Assert.assertFalse((name.equals("lop") || name.equals("ripple") ? 1 : 0) != 0);
            ++counter;
        }
        Assert.assertEquals((long)4L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_outXcreatedX_aggregateXxX_byXlangX_groupCount_programXTestProgramX_asXaX_selectXa_xX() {
        Traversal<Vertex, Map<String, Object>> traversal = this.get_g_V_outXcreatedX_aggregateXxX_byXlangX_groupCount_programXTestProgramX_asXaX_selectXa_xX();
        List results = traversal.toList();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)6L, (long)results.size());
        BulkSet bulkSet = new BulkSet();
        bulkSet.add((Object)"java", 4L);
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)bulkSet, ((Map)results.get(i)).get("x"));
        }
        HashSet<String> strings = new HashSet<String>();
        strings.add((String)((Map)results.get(0)).get("a"));
        strings.add((String)((Map)results.get(1)).get("a"));
        strings.add((String)((Map)results.get(2)).get("a"));
        strings.add((String)((Map)results.get(3)).get("a"));
        strings.add((String)((Map)results.get(4)).get("a"));
        strings.add((String)((Map)results.get(5)).get("a"));
        Assert.assertEquals((long)6L, (long)strings.size());
        Assert.assertTrue((boolean)strings.contains("hello"));
        Assert.assertTrue((boolean)strings.contains("gremlin"));
        Assert.assertTrue((boolean)strings.contains("lop"));
        Assert.assertTrue((boolean)strings.contains("ripple"));
        Assert.assertTrue((boolean)strings.contains("marko-is-my-name"));
        Assert.assertTrue((boolean)strings.contains("the-v-o-double-g"));
    }

    public static class TestProgram
    implements VertexProgram {
        private PureTraversal<?, ?> traversal = new PureTraversal((Traversal.Admin)EmptyTraversal.instance());
        private TraverserSet<Object> haltedTraversers;
        private Step programStep = EmptyStep.instance();
        private final Set<MemoryComputeKey> memoryComputeKeys = new HashSet<MemoryComputeKey>();

        public void loadState(Graph graph, Configuration configuration) {
            super.loadState(graph, configuration);
            this.traversal = PureTraversal.loadState((Configuration)configuration, (String)"gremlin.vertexProgramStep.rootTraversal", (Graph)graph);
            this.haltedTraversers = TraversalVertexProgram.loadHaltedTraversers((Configuration)configuration);
            this.programStep = new TraversalMatrix(this.traversal.get()).getStepById(configuration.getString("gremlin.vertexProgramStep.stepId"));
            this.memoryComputeKeys.addAll(MemoryTraversalSideEffects.getMemoryComputeKeys((Traversal.Admin)this.traversal.get()));
            this.memoryComputeKeys.add(MemoryComputeKey.of((String)"gremlin.traversalVertexProgram.haltedTraversers", (BinaryOperator)Operator.addAll, (boolean)false, (boolean)false));
            this.memoryComputeKeys.add(MemoryComputeKey.of((String)"gremlin.traversalVertexProgram.activeTraversers", (BinaryOperator)Operator.addAll, (boolean)true, (boolean)true));
        }

        public void storeState(Configuration configuration) {
            super.storeState(configuration);
            this.traversal.storeState(configuration, "gremlin.vertexProgramStep.rootTraversal");
            TraversalVertexProgram.storeHaltedTraversers((Configuration)configuration, this.haltedTraversers);
            configuration.setProperty("gremlin.vertexProgramStep.stepId", (Object)this.programStep.getId());
        }

        public void setup(Memory memory) {
            MemoryTraversalSideEffects.setMemorySideEffects((Traversal.Admin)this.traversal.get(), (Memory)memory, (ProgramPhase)ProgramPhase.SETUP);
            Map map = (Map)((Traverser.Admin)this.haltedTraversers.iterator().next()).get();
            Assert.assertEquals((long)2L, (long)map.size());
            Assert.assertTrue((boolean)map.values().contains(3L));
            Assert.assertTrue((boolean)map.values().contains(1L));
            TraverserSet activeTraversers = new TraverserSet();
            map.keySet().forEach(vertex -> activeTraversers.add(this.haltedTraversers.peek().split(vertex, (Step)EmptyStep.instance())));
            this.haltedTraversers.clear();
            this.checkSideEffects();
            memory.set("gremlin.traversalVertexProgram.activeTraversers", (Object)activeTraversers);
        }

        public void execute(Vertex vertex, Messenger messenger, Memory memory) {
            Assert.assertFalse((boolean)memory.exists("gremlin.traversalVertexProgram.haltedTraversers"));
            TraverserGenerator generator = this.traversal.get().getTraverserGenerator();
            MemoryTraversalSideEffects.setMemorySideEffects((Traversal.Admin)this.traversal.get(), (Memory)memory, (ProgramPhase)ProgramPhase.EXECUTE);
            this.checkSideEffects();
            TraverserSet activeTraversers = (TraverserSet)memory.get("gremlin.traversalVertexProgram.activeTraversers");
            if (vertex.label().equals("software")) {
                Assert.assertEquals((long)1L, (long)activeTraversers.stream().filter(v -> ((Vertex)v.get()).equals(vertex)).count());
                if (memory.isInitialIteration()) {
                    Assert.assertFalse((boolean)vertex.property("gremlin.traversalVertexProgram.haltedTraversers").isPresent());
                    vertex.property("gremlin.traversalVertexProgram.haltedTraversers", (Object)new TraverserSet(generator.generate(vertex.value("name"), this.programStep, 1L)));
                } else {
                    Assert.assertTrue((boolean)vertex.property("gremlin.traversalVertexProgram.haltedTraversers").isPresent());
                }
            } else {
                Assert.assertFalse((boolean)vertex.property("gremlin.traversalVertexProgram.haltedTraversers").isPresent());
                Assert.assertEquals((long)0L, (long)activeTraversers.stream().filter(v -> ((Vertex)v.get()).equals(vertex)).count());
                if (!memory.isInitialIteration()) {
                    if (vertex.value("name").equals("marko")) {
                        memory.add("gremlin.traversalVertexProgram.haltedTraversers", (Object)new TraverserSet(generator.generate((Object)"marko-is-my-name", this.programStep, 1L)));
                    } else if (vertex.value("name").equals("vadas")) {
                        this.traversal.get().getSideEffects().add("gremlin.traversalVertexProgram.haltedTraversers", (Object)new TraverserSet(generator.generate((Object)"the-v-o-double-g", this.programStep, 1L)));
                    }
                }
            }
        }

        public boolean terminate(Memory memory) {
            TraverserGenerator generator = this.traversal.get().getTraverserGenerator();
            MemoryTraversalSideEffects.setMemorySideEffects((Traversal.Admin)this.traversal.get(), (Memory)memory, (ProgramPhase)ProgramPhase.TERMINATE);
            this.checkSideEffects();
            if (memory.isInitialIteration()) {
                Assert.assertFalse((boolean)memory.exists("gremlin.traversalVertexProgram.haltedTraversers"));
                return false;
            }
            Assert.assertTrue((boolean)memory.exists("gremlin.traversalVertexProgram.haltedTraversers"));
            TraverserSet haltedTraversers = (TraverserSet)memory.get("gremlin.traversalVertexProgram.haltedTraversers");
            haltedTraversers.add(generator.generate((Object)"hello", this.programStep, 1L));
            haltedTraversers.add(generator.generate((Object)"gremlin", this.programStep, 1L));
            memory.set("gremlin.traversalVertexProgram.haltedTraversers", (Object)haltedTraversers);
            return true;
        }

        public void workerIterationStart(Memory memory) {
            Assert.assertNotNull(this.haltedTraversers);
            this.haltedTraversers.clear();
            Assert.assertFalse((boolean)memory.exists("gremlin.traversalVertexProgram.haltedTraversers"));
            MemoryTraversalSideEffects.setMemorySideEffects((Traversal.Admin)this.traversal.get(), (Memory)memory, (ProgramPhase)ProgramPhase.WORKER_ITERATION_START);
            this.checkSideEffects();
        }

        public void workerIterationEnd(Memory memory) {
            Assert.assertFalse((boolean)memory.exists("gremlin.traversalVertexProgram.haltedTraversers"));
            MemoryTraversalSideEffects.setMemorySideEffects((Traversal.Admin)this.traversal.get(), (Memory)memory, (ProgramPhase)ProgramPhase.WORKER_ITERATION_END);
            this.checkSideEffects();
        }

        public Set<VertexComputeKey> getVertexComputeKeys() {
            return Collections.singleton(VertexComputeKey.of((String)"gremlin.traversalVertexProgram.haltedTraversers", (boolean)false));
        }

        public Set<MemoryComputeKey> getMemoryComputeKeys() {
            return this.memoryComputeKeys;
        }

        public Set<MessageScope> getMessageScopes(Memory memory) {
            return Collections.emptySet();
        }

        public TestProgram clone() {
            try {
                TestProgram clone = (TestProgram)super.clone();
                clone.traversal = this.traversal.clone();
                clone.programStep = new TraversalMatrix(clone.traversal.get()).getStepById(this.programStep.getId());
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        public GraphComputer.ResultGraph getPreferredResultGraph() {
            return GraphComputer.ResultGraph.NEW;
        }

        public GraphComputer.Persist getPreferredPersist() {
            return GraphComputer.Persist.EDGES;
        }

        private void checkSideEffects() {
            Assert.assertEquals((long)0L, (long)this.haltedTraversers.size());
            Assert.assertTrue((boolean)this.haltedTraversers.isEmpty());
            TraversalSideEffects sideEffects = this.traversal.get().getSideEffects();
            Assert.assertTrue((boolean)(sideEffects instanceof MemoryTraversalSideEffects));
            Assert.assertEquals((long)1L, (long)sideEffects.keys().size());
            Assert.assertFalse((boolean)sideEffects.exists("gremlin.traversalVertexProgram.haltedTraversers"));
            Assert.assertTrue((boolean)sideEffects.exists("x"));
            BulkSet bulkSet = (BulkSet)sideEffects.get("x");
            Assert.assertEquals((long)4L, (long)bulkSet.size());
            Assert.assertEquals((long)4L, (long)bulkSet.get((Object)"java"));
        }
    }

    public static class Traversals
    extends ProgramTest {
        @Override
        public Traversal<Vertex, Vertex> get_g_V_programXpageRankX() {
            return this.g.V(new Object[0]).program(PageRankVertexProgram.build().create(this.graph));
        }

        @Override
        public Traversal<Vertex, Map<String, List<Object>>> get_g_V_hasLabelXpersonX_programXpageRank_rankX_order_byXrank_incrX_valueMapXname_rankX() {
            return this.g.V(new Object[0]).hasLabel((Object)"person", new Object[0]).program(PageRankVertexProgram.build().property("rank").create(this.graph)).order().by("rank", (Comparator)Order.incr).valueMap(new String[]{"name", "rank"});
        }

        @Override
        public Traversal<Vertex, Map<String, Object>> get_g_V_outXcreatedX_aggregateXxX_byXlangX_groupCount_programXTestProgramX_asXaX_selectXa_xX() {
            return this.g.V(new Object[0]).out(new String[]{"created"}).aggregate("x").by("lang").groupCount().program((VertexProgram)new TestProgram()).as("a", new String[0]).select("a", "x", new String[0]);
        }
    }
}

