/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.reference;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceEdge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class ReferenceVertexTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldHashAndEqualCorrectly() {
        Vertex v = this.graph.addVertex(new Object[0]);
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < 100; ++i) {
            set.add(ReferenceFactory.detach((Vertex)v));
            set.add(v);
        }
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotConstructNewWithSomethingAlreadyDetached() {
        Vertex v = this.graph.addVertex(new Object[0]);
        ReferenceVertex referenceVertex = ReferenceFactory.detach((Vertex)v);
        Assert.assertSame((Object)referenceVertex, (Object)ReferenceFactory.detach((Vertex)referenceVertex));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldConstructReferenceVertex() {
        Vertex v = this.graph.addVertex(new Object[]{T.label, "blah", "test", "123"});
        ReferenceVertex referenceVertex = ReferenceFactory.detach((Vertex)v);
        Assert.assertEquals((Object)v.id(), (Object)referenceVertex.id());
        Assert.assertEquals((Object)"blah", (Object)referenceVertex.label());
        Assert.assertEquals((Object)v.label(), (Object)referenceVertex.label());
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)referenceVertex.properties(new String[0])));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldEvaluateToEqualForVerticesAndDetachments() {
        Assert.assertTrue((boolean)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next())).equals((Object)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()))));
        Assert.assertTrue((boolean)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next())).equals(this.g.V(new Object[]{this.convertToVertexId("marko")}).next()));
        Assert.assertTrue((boolean)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next())).equals((Object)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true)));
        Assert.assertTrue((boolean)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next())).equals((Object)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)false)));
        Assert.assertTrue((boolean)((Boolean)ReferenceFactory.detach((Object)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).equals(ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()))))));
        Assert.assertTrue((boolean)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).equals(ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()))));
        Assert.assertTrue((boolean)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true).equals((Object)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()))));
        Assert.assertTrue((boolean)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)false).equals((Object)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()))));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveSameHashCode() {
        Assert.assertEquals((long)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next())).hashCode(), (long)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next())).hashCode());
        Assert.assertEquals((long)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next())).hashCode(), (long)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).hashCode());
        Assert.assertEquals((long)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next())).hashCode(), (long)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)false).hashCode());
        Assert.assertEquals((long)ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next())).hashCode(), (long)DetachedFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()), (boolean)true).hashCode());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToGraph() {
        Vertex v = (Vertex)this.g.V(new Object[]{this.convertToVertexId("josh")}).next();
        ReferenceVertex referenceVertex = ReferenceFactory.detach((Vertex)v);
        Vertex attachedV = (Vertex)referenceVertex.attach(Attachable.Method.get((Host)this.graph));
        Assert.assertEquals((Object)v, (Object)attachedV);
        Assert.assertFalse((boolean)(attachedV instanceof ReferenceVertex));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToVertex() {
        Vertex v = (Vertex)this.g.V(new Object[]{this.convertToVertexId("josh")}).next();
        ReferenceVertex referenceVertex = ReferenceFactory.detach((Vertex)v);
        Vertex attachedV = (Vertex)referenceVertex.attach(Attachable.Method.get((Host)v));
        Assert.assertEquals((Object)v, (Object)attachedV);
        Assert.assertFalse((boolean)(attachedV instanceof ReferenceVertex));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="IntegerValues")
    public void shouldNotEvaluateToEqualDifferentId() {
        ReferenceVertex originalMarko = ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()));
        Vertex secondMarko = this.graph.addVertex(new Object[]{"name", "marko", "age", 29});
        Assert.assertFalse((boolean)ReferenceFactory.detach((Vertex)secondMarko).equals((Object)originalMarko));
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotAllowAddEdge() {
        Vertex v = this.graph.addVertex(new Object[0]);
        ReferenceVertex rv = ReferenceFactory.detach((Vertex)v);
        rv.addEdge("test", null, new Object[0]);
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotAllowSetProperty() {
        Vertex v = this.graph.addVertex(new Object[0]);
        ReferenceVertex rv = ReferenceFactory.detach((Vertex)v);
        rv.property(VertexProperty.Cardinality.single, "test", (Object)"test", new Object[0]);
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotAllowRemove() {
        Vertex v = this.graph.addVertex(new Object[0]);
        ReferenceVertex rv = ReferenceFactory.detach((Vertex)v);
        rv.remove();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotHaveAnyProperties() {
        ReferenceVertex rv = ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()));
        Assert.assertFalse((boolean)rv.properties(new String[0]).hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotHaveAnyEdges() {
        ReferenceVertex rv = ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()));
        Assert.assertFalse((boolean)rv.edges(Direction.BOTH, new String[0]).hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotHaveAnyVertices() {
        ReferenceVertex rv = ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()));
        Assert.assertFalse((boolean)rv.vertices(Direction.BOTH, new String[0]).hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldDetachCollections() {
        ReferenceVertex vertex = ReferenceFactory.detach((Vertex)((Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next()));
        Assert.assertTrue((boolean)(vertex instanceof ReferenceVertex));
        List vertices = (List)ReferenceFactory.detach((Object)this.g.V(new Object[0]).hasLabel("software", new String[0]).fold().next());
        for (Object v : vertices) {
            Assert.assertTrue((boolean)(v instanceof ReferenceVertex));
        }
        List lists = (List)ReferenceFactory.detach((Object)this.g.V(new Object[0]).hasLabel("software", new String[0]).fold().fold().next());
        for (Object v : (List)lists.get(0)) {
            Assert.assertTrue((boolean)(v instanceof ReferenceVertex));
        }
        Set set = (Set)ReferenceFactory.detach((Object)this.g.V(new Object[0]).hasLabel("software", new String[0]).fold().toSet());
        for (Vertex v : (List)set.iterator().next()) {
            Assert.assertTrue((boolean)(v instanceof ReferenceVertex));
        }
        Map map = (Map)ReferenceFactory.detach((Object)this.g.V(new Object[0]).hasLabel("software", new String[0]).group().by().by((Traversal)__.inE((String[])new String[0]).fold()).next());
        for (Map.Entry entry : map.entrySet()) {
            Assert.assertTrue((boolean)(entry.getKey() instanceof ReferenceVertex));
            for (Edge edge : (List)entry.getValue()) {
                Assert.assertTrue((boolean)(edge instanceof ReferenceEdge));
                Assert.assertFalse((boolean)edge.property("weight").isPresent());
            }
        }
        map = (Map)ReferenceFactory.detach((Object)this.g.V(new Object[0]).hasLabel("software", new String[0]).group("m").by().by((Traversal)__.inE((String[])new String[0]).fold()).identity().cap("m", new String[0]).next());
        for (Map.Entry entry : map.entrySet()) {
            Assert.assertTrue((boolean)(entry.getKey() instanceof ReferenceVertex));
            for (Edge edge : (List)entry.getValue()) {
                Assert.assertTrue((boolean)(edge instanceof ReferenceEdge));
                Assert.assertFalse((boolean)edge.property("weight").isPresent());
            }
        }
    }
}

