/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.structure.Graph;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface LoadGraphWith {
    public static final String RESOURCE_PATH_PREFIX = "/org/apache/tinkerpop/gremlin/structure/io/gryo/";

    public GraphData value() default GraphData.CLASSIC;

    public static enum GraphData {
        CLASSIC,
        MODERN,
        CREW,
        GRATEFUL;

        private static final List<FeatureRequirement> featuresRequiredByClassic;
        private static final List<FeatureRequirement> featuresRequiredByCrew;
        private static final List<FeatureRequirement> featuresRequiredByModern;
        private static final List<FeatureRequirement> featuresRequiredByGrateful;

        public String location() {
            switch (this) {
                case CLASSIC: {
                    return "/org/apache/tinkerpop/gremlin/structure/io/gryo/tinkerpop-classic-v3d0.kryo";
                }
                case CREW: {
                    return "/org/apache/tinkerpop/gremlin/structure/io/gryo/tinkerpop-crew-v3d0.kryo";
                }
                case MODERN: {
                    return "/org/apache/tinkerpop/gremlin/structure/io/gryo/tinkerpop-modern-v3d0.kryo";
                }
                case GRATEFUL: {
                    return "/org/apache/tinkerpop/gremlin/structure/io/gryo/grateful-dead-v3d0.kryo";
                }
            }
            throw new RuntimeException("No file for this GraphData type");
        }

        public List<FeatureRequirement> featuresRequired() {
            switch (this) {
                case CLASSIC: {
                    return featuresRequiredByClassic;
                }
                case CREW: {
                    return featuresRequiredByCrew;
                }
                case MODERN: {
                    return featuresRequiredByModern;
                }
                case GRATEFUL: {
                    return featuresRequiredByGrateful;
                }
            }
            throw new RuntimeException("No features for this GraphData type");
        }

        static {
            featuresRequiredByClassic = new ArrayList<FeatureRequirement>(){
                {
                    this.add(FeatureRequirement.Factory.create("StringValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("IntegerValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("FloatValues", Graph.Features.EdgePropertyFeatures.class));
                }
            };
            featuresRequiredByCrew = new ArrayList<FeatureRequirement>(){
                {
                    this.add(FeatureRequirement.Factory.create("StringValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("IntegerValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("BooleanValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("MetaProperties", Graph.Features.VertexFeatures.class));
                    this.add(FeatureRequirement.Factory.create("MultiProperties", Graph.Features.VertexFeatures.class));
                }
            };
            featuresRequiredByModern = new ArrayList<FeatureRequirement>(){
                {
                    this.add(FeatureRequirement.Factory.create("StringValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("IntegerValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("DoubleValues", Graph.Features.EdgePropertyFeatures.class));
                }
            };
            featuresRequiredByGrateful = new ArrayList<FeatureRequirement>(){
                {
                    this.add(FeatureRequirement.Factory.create("StringValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("IntegerValues", Graph.Features.VertexPropertyFeatures.class));
                }
            };
        }
    }
}

