/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.PageRank;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class PageRankTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Vertex> get_g_V_pageRank_hasXpageRankX();

    public abstract Traversal<Vertex, Map<Object, List<Object>>> get_g_V_outXcreatedX_pageRank_withXedges_bothEX_withXpropertyName_projectRankXwithXtimes_0X_valueMapXname_projectRankX();

    public abstract Traversal<Vertex, String> get_g_V_pageRank_order_byXpageRank_descX_byXnameX_name();

    public abstract Traversal<Vertex, String> get_g_V_pageRank_order_byXpageRank_descX_name_limitX2X();

    public abstract Traversal<Vertex, Map<String, Object>> get_g_V_pageRank_withXedges_outEXknowsXX_withXpropertyName_friendRankX_project_byXnameX_byXvaluesXfriendRankX_mathX();

    public abstract Traversal<Vertex, Map<String, Object>> get_g_V_hasLabelXpersonX_pageRank_withXpropertyName_pageRankX_project_byXnameX_byXvaluesXpageRankX_mathX();

    public abstract Traversal<Vertex, Map<String, Object>> get_g_V_pageRank_withXpropertyName_pageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX_by_byXmathX();

    public abstract Traversal<Vertex, Map<Object, List<Object>>> get_g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_withXedges_inEXcreatedXX_withXtimes_1X_withXpropertyName_priorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX();

    public abstract Traversal<Vertex, Map<Object, List<Vertex>>> get_g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_withXpropertyName_pageRankXX_withXedges_inEXX_withXtimes_1X_inXcreatedX_groupXmX_byXpageRankX_capXmX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_pageRank_hasXpageRankX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_pageRank_hasXpageRankX();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)6L, (long)IteratorUtils.count(traversal));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_outXcreatedX_pageRank_withXedges_bothEX_withXpropertyName_projectRankXwithXtimes_0X_valueMapXname_projectRankX() {
        Traversal<Vertex, Map<Object, List<Object>>> traversal = this.get_g_V_outXcreatedX_pageRank_withXedges_bothEX_withXpropertyName_projectRankXwithXtimes_0X_valueMapXname_projectRankX();
        this.printTraversalForm(traversal);
        List result = traversal.toList();
        Assert.assertEquals((long)4L, (long)result.size());
        HashMap map = new HashMap();
        result.forEach(m -> map.put((String)((List)m.get("name")).get(0), (Double)((List)m.get("projectRank")).get(0)));
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey("lop"));
        Assert.assertTrue((boolean)map.containsKey("ripple"));
        Assert.assertTrue(((Double)map.get("lop") > (Double)map.get("ripple") ? 1 : 0) != 0);
        Assert.assertEquals((double)3.0, (double)((Double)map.get("lop")), (double)0.001);
        Assert.assertEquals((double)1.0, (double)((Double)map.get("ripple")), (double)0.001);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_pageRank_order_byXpageRank_descX_byXnameX_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_pageRank_order_byXpageRank_descX_byXnameX_name();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)6L, (long)names.size());
        Assert.assertEquals((Object)"lop", names.get(0));
        Assert.assertEquals((Object)"ripple", names.get(1));
        Assert.assertEquals((Object)"josh", names.get(2));
        Assert.assertEquals((Object)"vadas", names.get(3));
        Assert.assertEquals((Object)"marko", names.get(4));
        Assert.assertEquals((Object)"peter", names.get(5));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_pageRank_withXedges_outEXknowsXX_withXpropertyName_friendRankX_project_byXnameX_byXvaluesXfriendRankX_mathX() {
        Traversal<Vertex, Map<String, Object>> traversal = this.get_g_V_pageRank_withXedges_outEXknowsXX_withXpropertyName_friendRankX_project_byXnameX_byXvaluesXfriendRankX_mathX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)map.size());
            String name = (String)map.get("name");
            Double friendRank = (Double)map.get("friendRank");
            if (name.equals("lop") || name.equals("ripple") || name.equals("peter") || name.equals("marko")) {
                Assert.assertEquals((double)15.0, (double)friendRank, (double)0.01);
            } else {
                Assert.assertEquals((double)21.0, (double)friendRank, (double)0.01);
            }
            ++counter;
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_pageRank_order_byXpageRank_descX_name_limitX2X() {
        Traversal<Vertex, String> traversal = this.get_g_V_pageRank_order_byXpageRank_descX_name_limitX2X();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)2L, (long)names.size());
        Assert.assertEquals((Object)"lop", names.get(0));
        Assert.assertEquals((Object)"ripple", names.get(1));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_pageRank_withXpropertyName_pageRankX_project_byXnameX_byXvaluesXpageRankX_mathX() {
        Traversal<Vertex, Map<String, Object>> traversal = this.get_g_V_hasLabelXpersonX_pageRank_withXpropertyName_pageRankX_project_byXnameX_byXvaluesXpageRankX_mathX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)map.size());
            String name = (String)map.get("name");
            Double pageRank = (Double)map.get("pageRank");
            if (name.equals("marko") || name.equals("peter")) {
                Assert.assertEquals((double)46.0, (double)pageRank, (double)0.01);
            } else {
                Assert.assertEquals((double)59.0, (double)pageRank, (double)0.01);
            }
            ++counter;
        }
        Assert.assertEquals((long)4L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_pageRank_withXpropertyName_pageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX_by_byXmathX() {
        Traversal<Vertex, Map<String, Object>> traversal = this.get_g_V_pageRank_withXpropertyName_pageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX_by_byXmathX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)map.size());
            Vertex vertex = (Vertex)map.get("a");
            double pageRank = (Double)map.get("b");
            Assert.assertEquals((Object)this.convertToVertexId("marko"), (Object)vertex.id());
            Assert.assertTrue((pageRank > 0.1 ? 1 : 0) != 0);
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_withXedges_inEXcreatedXX_withXtimes_1X_withXpropertyName_priorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX() {
        Traversal<Vertex, Map<Object, List<Object>>> traversal = this.get_g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_withXedges_inEXcreatedXX_withXtimes_1X_withXpropertyName_priorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            Map map = (Map)traversal.next();
            Assert.assertEquals((long)2L, (long)map.size());
            String name = (String)((List)map.get("name")).get(0);
            double pageRank = (Double)((List)map.get("priors")).get(0);
            Assert.assertEquals((double)(name.equals("josh") ? 1.0 : 0.0), (double)pageRank, (double)1.0E-4);
            if (name.equals("peter") || name.equals("vadas")) {
                Assert.fail((String)"Peter or Vadas should not have been accessed");
            }
            ++counter;
        }
        Assert.assertEquals((long)4L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_withXPROPERTY_NAME_pageRankXX_withXEDGES_inEXX_withXTIMES_1X_inXcreatedX_groupXmX_byXpageRankX_capXmX() {
        Traversal<Vertex, Map<Object, List<Vertex>>> traversal = this.get_g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_withXpropertyName_pageRankXX_withXedges_inEXX_withXtimes_1X_inXcreatedX_groupXmX_byXpageRankX_capXmX();
        this.printTraversalForm(traversal);
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey("software"));
        map.forEach((k, v) -> {
            boolean found = false;
            if (!k.equals("software") && v.size() == 4) {
                Assert.assertEquals((double)2.0, (double)((Number)k).doubleValue(), (double)0.01);
                Assert.assertEquals((long)4L, (long)v.stream().filter(vertex -> vertex.id().equals(this.convertToVertexId(this.graph, "josh"))).count());
                found = true;
            } else if (v.size() == 6) {
                Assert.assertEquals((double)1.0, (double)((Number)k).doubleValue(), (double)0.01);
                Assert.assertEquals((long)3L, (long)v.stream().filter(vertex -> vertex.id().equals(this.convertToVertexId(this.graph, "peter"))).count());
                Assert.assertEquals((long)3L, (long)v.stream().filter(vertex -> vertex.id().equals(this.convertToVertexId(this.graph, "marko"))).count());
                found = true;
            } else if (v.size() == 4) {
                Assert.assertEquals((Object)"software", (Object)k);
                Assert.assertEquals((long)3L, (long)v.stream().filter(vertex -> vertex.id().equals(this.convertToVertexId(this.graph, "lop"))).count());
                Assert.assertEquals((long)1L, (long)v.stream().filter(vertex -> vertex.id().equals(this.convertToVertexId(this.graph, "ripple"))).count());
                found = true;
            }
            if (!found) {
                Assert.fail((String)("There are too many key/values: " + k + "--" + v));
            }
        });
    }

    public static class Traversals
    extends PageRankTest {
        @Override
        public Traversal<Vertex, Vertex> get_g_V_pageRank_hasXpageRankX() {
            return this.g.V(new Object[0]).pageRank().has("gremlin.pageRankVertexProgram.pageRank");
        }

        @Override
        public Traversal<Vertex, Map<Object, List<Object>>> get_g_V_outXcreatedX_pageRank_withXedges_bothEX_withXpropertyName_projectRankXwithXtimes_0X_valueMapXname_projectRankX() {
            return this.g.V(new Object[0]).out(new String[]{"created"}).pageRank().with(PageRank.edges, (Object)__.bothE((String[])new String[0])).with(PageRank.propertyName, (Object)"projectRank").with(PageRank.times, (Object)0).valueMap(new String[]{"name", "projectRank"});
        }

        @Override
        public Traversal<Vertex, Map<String, Object>> get_g_V_pageRank_withXedges_outEXknowsXX_withXpropertyName_friendRankX_project_byXnameX_byXvaluesXfriendRankX_mathX() {
            return this.g.V(new Object[0]).pageRank().with(PageRank.edges, (Object)__.outE((String[])new String[]{"knows"})).with(PageRank.propertyName, (Object)"friendRank").project("name", new String[]{"friendRank"}).by("name").by((Traversal)__.values((String[])new String[]{"friendRank"}).math("ceil(_ * 100)"));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_pageRank_order_byXpageRank_descX_byXnameX_name() {
            return this.g.V(new Object[0]).pageRank().order().by("gremlin.pageRankVertexProgram.pageRank", (Comparator)Order.desc).by("name").values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_pageRank_order_byXpageRank_descX_name_limitX2X() {
            return this.g.V(new Object[0]).pageRank().order().by("gremlin.pageRankVertexProgram.pageRank", (Comparator)Order.desc).values(new String[]{"name"}).limit(2L);
        }

        @Override
        public Traversal<Vertex, Map<String, Object>> get_g_V_hasLabelXpersonX_pageRank_withXpropertyName_pageRankX_project_byXnameX_byXvaluesXpageRankX_mathX() {
            return this.g.V(new Object[0]).hasLabel("person", new String[0]).pageRank().with(PageRank.propertyName, (Object)"pageRank").project("name", new String[]{"pageRank"}).by("name").by((Traversal)__.values((String[])new String[]{"pageRank"}).math("ceil(_ * 100)"));
        }

        @Override
        public Traversal<Vertex, Map<String, Object>> get_g_V_pageRank_withXpropertyName_pageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX_by_byXmathX() {
            return this.g.V(new Object[0]).pageRank().with(PageRank.propertyName, (Object)"pageRank").as("a", new String[0]).out(new String[]{"knows"}).values(new String[]{"pageRank"}).as("b", new String[0]).select("a", "b", new String[0]).by().by((Traversal)__.math((String)"ceil(_ * 100)"));
        }

        @Override
        public Traversal<Vertex, Map<Object, List<Object>>> get_g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_withXedges_inEXcreatedXX_withXtimes_1X_withXpropertyName_priorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX() {
            return this.g.V(new Object[0]).hasLabel("software", new String[0]).has("name", (Object)"ripple").pageRank(1.0).with(PageRank.edges, (Object)__.inE((String[])new String[]{"created"})).with(PageRank.times, (Object)1).with(PageRank.propertyName, (Object)"priors").in(new String[]{"created"}).union(new Traversal[]{__.both((String[])new String[0]), __.identity()}).valueMap(new String[]{"name", "priors"});
        }

        @Override
        public Traversal<Vertex, Map<Object, List<Vertex>>> get_g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_withXpropertyName_pageRankXX_withXedges_inEXX_withXtimes_1X_inXcreatedX_groupXmX_byXpageRankX_capXmX() {
            return this.g.V(new Object[0]).out(new String[]{"created"}).group("m").by(T.label).pageRank(1.0).with(PageRank.propertyName, (Object)"pageRank").with(PageRank.edges, (Object)__.inE((String[])new String[0])).with(PageRank.times, (Object)1).in(new String[]{"created"}).group("m").by("pageRank").cap("m", new String[0]);
        }
    }
}

