/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.features;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;

public class FeatureReader {
    public static Map<String, List<String>> parse(String projectRoot) throws IOException {
        LinkedHashMap<String, List<String>> gremlins = new LinkedHashMap<String, List<String>>();
        Files.find(Paths.get(projectRoot, "gremlin-test", "features"), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && filePath.toString().endsWith(".feature"), new FileVisitOption[0]).sorted().forEach(f -> {
            String currentGremlin = "";
            boolean openTriples = false;
            boolean skipIgnored = false;
            String scenarioName = "";
            try {
                List<String> lines = Files.readAllLines(f, StandardCharsets.UTF_8);
                for (String line : lines) {
                    String cleanLine = line.trim();
                    if (cleanLine.startsWith("Scenario:")) {
                        scenarioName = cleanLine.split(":")[1].trim();
                        skipIgnored = false;
                        continue;
                    }
                    if (cleanLine.startsWith("Then nothing should happen because")) {
                        skipIgnored = true;
                        continue;
                    }
                    if (cleanLine.startsWith("And the graph should return")) {
                        gremlins.computeIfAbsent(scenarioName, k -> new ArrayList()).add(StringEscapeUtils.unescapeJava((String)cleanLine.substring(cleanLine.indexOf("\"") + 1, cleanLine.lastIndexOf("\""))));
                        continue;
                    }
                    if (cleanLine.startsWith("\"\"\"")) {
                        boolean bl = openTriples = !openTriples;
                        if (skipIgnored || openTriples) continue;
                        gremlins.computeIfAbsent(scenarioName, k -> new ArrayList()).add(currentGremlin);
                        currentGremlin = "";
                        continue;
                    }
                    if (!openTriples || skipIgnored) continue;
                    currentGremlin = currentGremlin + cleanLine;
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        });
        return gremlins;
    }
}

