/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.Comparator;
import java.util.List;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.EarlyLimitStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public class EarlyLimitStrategyProcessTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void shouldHandleRangeSteps() throws Exception {
        GraphTraversal t = this.g.V(new Object[0]).has("artist", "name", (Object)"Bob_Dylan").in(new String[]{"sungBy"}).order().by("performances", (Comparator)Order.desc).as("a", new String[0]).repeat((Traversal)__.out((String[])new String[]{"followedBy"}).order().by("performances", (Comparator)Order.desc).simplePath().from("a")).until((Traversal)__.out((String[])new String[]{"writtenBy"}).has("name", (Object)"Johnny_Cash")).limit(1L).as("b", new String[0]).repeat((Traversal)__.out((String[])new String[]{"followedBy"}).order().by("performances", (Comparator)Order.desc).as("c", new String[0]).simplePath().from("b").to("c")).until((Traversal)__.out((String[])new String[]{"sungBy"}).has("name", (Object)"Grateful_Dead")).limit(5L).as("d", new String[0]).path().from("a").limit(1L).as("e", new String[0]).unfold().project("song", new String[]{"artists"}).by("name").by((Traversal)__.coalesce((Traversal[])new Traversal[]{__.out((String[])new String[]{"sungBy", "writtenBy"}).dedup(new String[0]).values(new String[]{"name"}), __.constant((Object)"Unknown")}).fold());
        GraphTraversal pt = t.asAdmin().clone().profile();
        List result = t.toList();
        TraversalMetrics metrics = (TraversalMetrics)pt.next();
        Assert.assertEquals((long)6L, (long)result.size());
        Assume.assumeTrue((String)"The following assertions apply to TinkerGraph only as provider strategies can alter the steps to not comply with expectations", (boolean)this.graph.getClass().getSimpleName().equals("TinkerGraph"));
        if (t.asAdmin().getStrategies().getStrategy(EarlyLimitStrategy.class).isPresent()) {
            Assert.assertEquals((long)10L, (long)metrics.getMetrics().size());
            MatcherAssert.assertThat((Object)metrics.getMetrics(5).getName().endsWith("@[d]"), (Matcher)Matchers.is((Object)true));
            Assert.assertEquals((Object)"RangeGlobalStep(0,1)", (Object)metrics.getMetrics(6).getName());
            Assert.assertEquals((Object)"PathStep@[e]", (Object)metrics.getMetrics(7).getName());
            MatcherAssert.assertThat((Object)metrics.getMetrics(7).getCounts().values().stream().allMatch(x -> x == 1L), (Matcher)Matchers.is((Object)true));
        } else {
            Assert.assertEquals((long)11L, (long)metrics.getMetrics().size());
            Assert.assertEquals((Object)"RangeGlobalStep(0,5)@[d]", (Object)metrics.getMetrics(6).getName());
            Assert.assertEquals((Object)"PathStep", (Object)metrics.getMetrics(7).getName());
            Assert.assertEquals((Object)"RangeGlobalStep(0,1)@[e]", (Object)metrics.getMetrics(8).getName());
        }
    }
}

