/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank.PageRankVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class PageRankVertexProgramTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldExecutePageRankWithIterationsBreak() throws Exception {
        if (this.graphProvider.getGraphComputer(this.graph).features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.NEW, GraphComputer.Persist.VERTEX_PROPERTIES)) {
            ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(PageRankVertexProgram.build().epsilon(0.0).iterations(30).create(this.graph)).submit().get();
            result.graph().traversal().V(new Object[0]).forEachRemaining(v -> {
                Assert.assertEquals((long)3L, (long)v.keys().size());
                Assert.assertTrue((boolean)v.keys().contains("name"));
                Assert.assertTrue((boolean)v.keys().contains("gremlin.pageRankVertexProgram.pageRank"));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.values(new String[]{"name"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.values(new String[]{"gremlin.pageRankVertexProgram.pageRank"})));
                String name = (String)v.value("name");
                Double pageRank = (Double)v.value("gremlin.pageRankVertexProgram.pageRank");
                if (name.equals("marko")) {
                    Assert.assertTrue((pageRank > 0.1 && pageRank < 0.12 ? 1 : 0) != 0);
                } else if (name.equals("vadas")) {
                    Assert.assertTrue((pageRank > 0.13 && pageRank < 0.15 ? 1 : 0) != 0);
                } else if (name.equals("lop")) {
                    Assert.assertTrue((pageRank > 0.29 && pageRank < 0.31 ? 1 : 0) != 0);
                } else if (name.equals("josh")) {
                    Assert.assertTrue((pageRank > 0.13 && pageRank < 0.15 ? 1 : 0) != 0);
                } else if (name.equals("ripple")) {
                    Assert.assertTrue((pageRank > 0.16 && pageRank < 0.18 ? 1 : 0) != 0);
                } else if (name.equals("peter")) {
                    Assert.assertTrue((pageRank > 0.1 && pageRank < 0.12 ? 1 : 0) != 0);
                } else {
                    throw new IllegalStateException("The following vertex should not exist in the graph: " + name);
                }
            });
            Assert.assertEquals((long)result.memory().getIteration(), (long)30L);
            Assert.assertEquals((long)result.memory().asMap().size(), (long)0L);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldExecutePageRankWithEpsilonBreak() throws Exception {
        if (this.graphProvider.getGraphComputer(this.graph).features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.NEW, GraphComputer.Persist.VERTEX_PROPERTIES)) {
            ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).vertexProperties((Traversal)__.properties((String[])new String[]{"name", "age", "lang"})).program(PageRankVertexProgram.build().epsilon(1.0E-5).iterations(30).create(this.graph)).submit().get();
            result.graph().traversal().V(new Object[0]).forEachRemaining(v -> {
                Assert.assertEquals((long)3L, (long)v.keys().size());
                Assert.assertTrue((boolean)v.keys().contains("name"));
                Assert.assertTrue((boolean)v.keys().contains("gremlin.pageRankVertexProgram.pageRank"));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.values(new String[]{"name"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.values(new String[]{"gremlin.pageRankVertexProgram.pageRank"})));
                String name = (String)v.value("name");
                Double pageRank = (Double)v.value("gremlin.pageRankVertexProgram.pageRank");
                if (name.equals("marko")) {
                    Assert.assertTrue((pageRank > 0.1 && pageRank < 0.12 ? 1 : 0) != 0);
                } else if (name.equals("vadas")) {
                    Assert.assertTrue((pageRank > 0.13 && pageRank < 0.15 ? 1 : 0) != 0);
                } else if (name.equals("lop")) {
                    Assert.assertTrue((pageRank > 0.29 && pageRank < 0.31 ? 1 : 0) != 0);
                } else if (name.equals("josh")) {
                    Assert.assertTrue((pageRank > 0.13 && pageRank < 0.15 ? 1 : 0) != 0);
                } else if (name.equals("ripple")) {
                    Assert.assertTrue((pageRank > 0.16 && pageRank < 0.18 ? 1 : 0) != 0);
                } else if (name.equals("peter")) {
                    Assert.assertTrue((pageRank > 0.1 && pageRank < 0.12 ? 1 : 0) != 0);
                } else {
                    throw new IllegalStateException("The following vertex should not exist in the graph: " + name);
                }
            });
            Assert.assertEquals((long)result.memory().getIteration(), (long)11L);
            Assert.assertEquals((long)result.memory().asMap().size(), (long)0L);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldExecutePageRankWithEnergyConservation() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(PageRankVertexProgram.build().create(this.graph)).submit().get();
        double sum = ((Number)result.graph().traversal().V(new Object[0]).values(new String[]{"gremlin.pageRankVertexProgram.pageRank"}).sum().next()).doubleValue();
        Assert.assertEquals((double)1.0, (double)sum, (double)0.01);
    }
}

