/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io.gryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoRegistryAwareKryoSerializer
extends KryoSerializer {
    private final SparkConf conf;
    private static final Logger log = LoggerFactory.getLogger(IoRegistryAwareKryoSerializer.class);

    public IoRegistryAwareKryoSerializer(SparkConf conf) {
        super(conf);
        this.conf = conf;
    }

    public Kryo newKryo() {
        Kryo kryo = super.newKryo();
        return this.applyIoRegistryIfPresent(kryo);
    }

    private Kryo applyIoRegistryIfPresent(Kryo kryo) {
        if (!this.conf.contains("gremlin.io.registry")) {
            log.info("SparkConf {} does not contain setting {}, skipping {} handling", new Object[]{"gremlin.io.registry", this.conf, IoRegistry.class.getCanonicalName()});
            return kryo;
        }
        String registryClassnames = this.conf.get("gremlin.io.registry");
        for (String registryClassname : registryClassnames.split(",")) {
            IoRegistry registry;
            try {
                registry = (IoRegistry)Class.forName(registryClassname).newInstance();
                log.info("Instantiated {}", (Object)registryClassname);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error("Unable to reflectively instantiate the {} implementation named {}", new Object[]{IoRegistry.class.getCanonicalName(), registryClassname, e});
                return kryo;
            }
            List serializers = registry.find(GryoIo.class);
            if (null == serializers) {
                log.info("Invoking find({}.class) returned null on registry {}; ignoring this registry", (Object)GryoIo.class.getCanonicalName(), (Object)registry);
                return kryo;
            }
            for (Pair p : serializers) {
                if (null == p.getValue1()) {
                    log.info("Registering {} with default serializer", p.getValue0());
                    kryo.register((Class)p.getValue0());
                    continue;
                }
                if (p.getValue1() instanceof Serializer) {
                    log.info("Registering {} with serializer {}", p.getValue0(), p.getValue1());
                    kryo.register((Class)p.getValue0(), (Serializer)p.getValue1());
                    continue;
                }
                log.error("Serializer {} found in {} must implement {} (the shaded interface {} is not supported on Spark).  This class will be registered with the default behavior of Spark's KryoSerializer.", new Object[]{p.getValue1(), registryClassname, Serializer.class.getCanonicalName(), org.apache.tinkerpop.shaded.kryo.Serializer.class.getCanonicalName()});
                kryo.register((Class)p.getValue0());
            }
        }
        return kryo;
    }
}

