/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io.gryo.kryoshim.unshaded;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.spark.SparkConf;
import org.apache.tinkerpop.gremlin.spark.structure.io.gryo.IoRegistryAwareKryoSerializer;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnshadedKryoShimService
implements KryoShimService {
    private static final Logger log = LoggerFactory.getLogger(UnshadedKryoShimService.class);
    private static final LinkedBlockingQueue<Kryo> KRYOS = new LinkedBlockingQueue();
    private static volatile boolean initialized;

    public Object readClassAndObject(InputStream source) {
        LinkedBlockingQueue<Kryo> kryos = this.initialize();
        Kryo k = null;
        try {
            k = kryos.take();
            Object object = k.readClassAndObject(new Input(source));
            return object;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                kryos.put(k);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void writeClassAndObject(Object o, OutputStream sink) {
        LinkedBlockingQueue<Kryo> kryos = this.initialize();
        Kryo k = null;
        try {
            k = kryos.take();
            Output kryoOutput = new Output(sink);
            k.writeClassAndObject(kryoOutput, o);
            kryoOutput.flush();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                kryos.put(k);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int getPriority() {
        return -50;
    }

    public void applyConfiguration(Configuration conf) {
        this.initialize(conf);
    }

    private LinkedBlockingQueue<Kryo> initialize() {
        return this.initialize((Configuration)new BaseConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LinkedBlockingQueue<Kryo> initialize(Configuration conf) {
        if (initialized) return KRYOS;
        Class<UnshadedKryoShimService> clazz = UnshadedKryoShimService.class;
        synchronized (UnshadedKryoShimService.class) {
            if (initialized) return KRYOS;
            SparkConf sparkConf = new SparkConf();
            String regStr = conf.getString("gremlin.io.registry");
            if (null != regStr) {
                sparkConf.set("gremlin.io.registry", regStr);
            }
            sparkConf.set("spark.serializer", IoRegistryAwareKryoSerializer.class.getCanonicalName());
            String registrator = conf.getString("spark.kryo.registrator");
            if (null != registrator) {
                sparkConf.set("spark.kryo.registrator", registrator);
                log.info("Copied spark.kryo.registrator: {}", (Object)registrator);
            } else {
                log.info("Not copying spark.kryo.registrator");
            }
            int poolSize = conf.getInt("gremlin.io.gryo.poolSize", 256);
            IoRegistryAwareKryoSerializer ioReg = new IoRegistryAwareKryoSerializer(sparkConf);
            for (int i = 0; i < poolSize; ++i) {
                KRYOS.add(ioReg.newKryo());
            }
            initialized = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return KRYOS;
        }
    }
}

