/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.spark.structure.Spark;
import org.apache.tinkerpop.gremlin.spark.structure.io.InputRDD;
import scala.Tuple2;

public final class InputRDDFormat
extends InputFormat<NullWritable, VertexWritable> {
    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return Collections.singletonList(new InputSplit(){

            public long getLength() throws IOException, InterruptedException {
                return 0L;
            }

            public String[] getLocations() throws IOException, InterruptedException {
                return new String[0];
            }
        });
    }

    public RecordReader<NullWritable, VertexWritable> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        try {
            Configuration hadoopConfiguration = taskAttemptContext.getConfiguration();
            SparkConf sparkConfiguration = new SparkConf();
            sparkConfiguration.setAppName(UUID.randomUUID().toString());
            hadoopConfiguration.forEach(entry -> sparkConfiguration.set((String)entry.getKey(), (String)entry.getValue()));
            InputRDD inputRDD = (InputRDD)Class.forName(sparkConfiguration.get("gremlin.hadoop.graphReader")).newInstance();
            JavaSparkContext javaSparkContext = new JavaSparkContext(Spark.create(sparkConfiguration));
            final Iterator iterator = inputRDD.readGraphRDD(ConfUtil.makeApacheConfiguration((Configuration)taskAttemptContext.getConfiguration()), javaSparkContext).toLocalIterator();
            return new RecordReader<NullWritable, VertexWritable>(){

                public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    return iterator.hasNext();
                }

                public NullWritable getCurrentKey() throws IOException, InterruptedException {
                    return NullWritable.get();
                }

                public VertexWritable getCurrentValue() throws IOException, InterruptedException {
                    return (VertexWritable)((Tuple2)iterator.next())._2();
                }

                public float getProgress() throws IOException, InterruptedException {
                    return 1.0f;
                }

                public void close() throws IOException {
                }
            };
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

