/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopConfiguration;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.spark.structure.io.InputFormatRDD;
import org.apache.tinkerpop.gremlin.spark.structure.io.InputRDD;
import org.apache.tinkerpop.gremlin.spark.structure.io.OutputFormatRDD;
import org.apache.tinkerpop.gremlin.spark.structure.io.OutputRDD;
import org.apache.tinkerpop.gremlin.spark.structure.io.PersistedInputRDD;
import org.apache.tinkerpop.gremlin.spark.structure.io.PersistedOutputRDD;

public final class InputOutputHelper {
    private static Map<Class<? extends InputRDD>, Class<? extends OutputRDD>> INPUT_TO_OUTPUT_CACHE = new ConcurrentHashMap<Class<? extends InputRDD>, Class<? extends OutputRDD>>();
    private static Map<Class<? extends OutputRDD>, Class<? extends InputRDD>> OUTPUT_TO_INPUT_CACHE = new ConcurrentHashMap<Class<? extends OutputRDD>, Class<? extends InputRDD>>();

    private InputOutputHelper() {
    }

    public static Class<? extends InputRDD> getInputFormat(Class<? extends OutputRDD> outputRDD) {
        return OUTPUT_TO_INPUT_CACHE.get(outputRDD);
    }

    public static Class<? extends OutputRDD> getOutputFormat(Class<? extends InputRDD> inputRDD) {
        return INPUT_TO_OUTPUT_CACHE.get(inputRDD);
    }

    public static void registerInputOutputPair(Class<? extends InputRDD> inputRDD, Class<? extends OutputRDD> outputRDD) {
        INPUT_TO_OUTPUT_CACHE.put(inputRDD, outputRDD);
        OUTPUT_TO_INPUT_CACHE.put(outputRDD, inputRDD);
    }

    public static HadoopGraph getOutputGraph(Configuration configuration, GraphComputer.ResultGraph resultGraph, GraphComputer.Persist persist) {
        HadoopConfiguration hadoopConfiguration = new HadoopConfiguration(configuration);
        BaseConfiguration newConfiguration = new BaseConfiguration();
        newConfiguration.copy((Configuration)org.apache.tinkerpop.gremlin.hadoop.structure.io.InputOutputHelper.getOutputGraph((Configuration)configuration, (GraphComputer.ResultGraph)resultGraph, (GraphComputer.Persist)persist).configuration());
        if (resultGraph.equals((Object)GraphComputer.ResultGraph.NEW) && hadoopConfiguration.containsKey("gremlin.hadoop.graphWriter") && null != InputOutputHelper.getInputFormat(hadoopConfiguration.getGraphWriter())) {
            newConfiguration.setProperty("gremlin.hadoop.graphReader", (Object)InputOutputHelper.getInputFormat(hadoopConfiguration.getGraphWriter()).getCanonicalName());
        }
        return HadoopGraph.open((Configuration)newConfiguration);
    }

    static {
        INPUT_TO_OUTPUT_CACHE.put(PersistedInputRDD.class, PersistedOutputRDD.class);
        INPUT_TO_OUTPUT_CACHE.put(InputFormatRDD.class, OutputFormatRDD.class);
        OUTPUT_TO_INPUT_CACHE.put(PersistedOutputRDD.class, PersistedInputRDD.class);
        OUTPUT_TO_INPUT_CACHE.put(OutputFormatRDD.class, InputFormatRDD.class);
    }
}

