/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.computer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertexProperty;

public final class TinkerGraphComputerView {
    private final TinkerGraph graph;
    protected final Set<String> computeKeys;
    private Map<Element, Map<String, List<VertexProperty<?>>>> computeProperties;

    public TinkerGraphComputerView(TinkerGraph graph, Set<String> computeKeys) {
        this.graph = graph;
        this.computeKeys = computeKeys;
        this.computeProperties = new ConcurrentHashMap();
    }

    public <V> Property<V> addProperty(final TinkerVertex vertex, final String key, V value) {
        ElementHelper.validateProperty((String)key, value);
        if (this.isComputeKey(key)) {
            TinkerVertexProperty property = new TinkerVertexProperty<V>(vertex, key, value, new Object[0]){

                @Override
                public void remove() {
                    TinkerGraphComputerView.this.removeProperty(vertex, key, this);
                }
            };
            this.addValue(vertex, key, property);
            return property;
        }
        throw GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey((String)key);
    }

    public List<VertexProperty<?>> getProperty(TinkerVertex vertex, String key) {
        return this.isComputeKey(key) ? this.getValue(vertex, key) : TinkerHelper.getProperties(vertex).getOrDefault(key, Collections.emptyList());
    }

    public List<Property> getProperties(TinkerVertex vertex) {
        Stream a = TinkerHelper.getProperties(vertex).values().stream().flatMap(list -> list.stream());
        Stream b = this.computeProperties.containsKey(vertex) ? this.computeProperties.get(vertex).values().stream().flatMap(list -> list.stream()) : Stream.empty();
        return Stream.concat(a, b).collect(Collectors.toList());
    }

    public void removeProperty(TinkerVertex vertex, String key, VertexProperty property) {
        if (!this.isComputeKey(key)) {
            throw GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey((String)key);
        }
        this.removeValue(vertex, key, property);
    }

    public Graph processResultGraphPersist(GraphComputer.ResultGraph resultGraph, GraphComputer.Persist persist) {
        if (GraphComputer.Persist.NOTHING == persist) {
            if (GraphComputer.ResultGraph.ORIGINAL == resultGraph) {
                return this.graph;
            }
            return EmptyGraph.instance();
        }
        if (GraphComputer.Persist.VERTEX_PROPERTIES == persist) {
            if (GraphComputer.ResultGraph.ORIGINAL == resultGraph) {
                this.addPropertiesToOriginalGraph();
                return this.graph;
            }
            TinkerGraph newGraph = TinkerGraph.open();
            this.graph.vertices(new Object[0]).forEachRemaining(vertex -> {
                Vertex newVertex = newGraph.addVertex(T.id, vertex.id(), T.label, vertex.label());
                vertex.properties(new String[0]).forEachRemaining(vertexProperty -> {
                    VertexProperty newVertexProperty = newVertex.property(VertexProperty.Cardinality.list, vertexProperty.key(), vertexProperty.value(), new Object[]{T.id, vertexProperty.id()});
                    vertexProperty.properties(new String[0]).forEachRemaining(property -> newVertexProperty.property(property.key(), property.value()));
                });
            });
            return newGraph;
        }
        if (GraphComputer.ResultGraph.ORIGINAL == resultGraph) {
            this.addPropertiesToOriginalGraph();
            return this.graph;
        }
        TinkerGraph newGraph = TinkerGraph.open();
        this.graph.vertices(new Object[0]).forEachRemaining(vertex -> {
            Vertex newVertex = newGraph.addVertex(T.id, vertex.id(), T.label, vertex.label());
            vertex.properties(new String[0]).forEachRemaining(vertexProperty -> {
                VertexProperty newVertexProperty = newVertex.property(VertexProperty.Cardinality.list, vertexProperty.key(), vertexProperty.value(), new Object[]{T.id, vertexProperty.id()});
                vertexProperty.properties(new String[0]).forEachRemaining(property -> newVertexProperty.property(property.key(), property.value()));
            });
        });
        this.graph.edges(new Object[0]).forEachRemaining(edge -> {
            Vertex outVertex = newGraph.vertices(edge.outVertex().id()).next();
            Vertex inVertex = newGraph.vertices(edge.inVertex().id()).next();
            Edge newEdge = outVertex.addEdge(edge.label(), inVertex, new Object[]{T.id, edge.id()});
            edge.properties(new String[0]).forEachRemaining(property -> newEdge.property(property.key(), property.value()));
        });
        return newGraph;
    }

    private void addPropertiesToOriginalGraph() {
        TinkerHelper.dropGraphComputerView(this.graph);
        this.computeProperties.forEach((element, properties) -> properties.forEach((key, vertexProperties) -> vertexProperties.forEach(vertexProperty -> {
            VertexProperty newVertexProperty = ((Vertex)element).property(VertexProperty.Cardinality.list, vertexProperty.key(), vertexProperty.value(), new Object[]{T.id, vertexProperty.id()});
            vertexProperty.properties(new String[0]).forEachRemaining(property -> newVertexProperty.property(property.key(), property.value()));
        })));
        this.computeProperties.clear();
    }

    private boolean isComputeKey(String key) {
        return this.computeKeys.contains(key);
    }

    private void addValue(Vertex vertex, String key, VertexProperty property) {
        Map elementProperties = this.computeProperties.computeIfAbsent((Element)vertex, k -> new ConcurrentHashMap());
        elementProperties.compute(key, (k, v) -> {
            if (null == v) {
                v = Collections.synchronizedList(new ArrayList());
            }
            v.add(property);
            return v;
        });
    }

    private void removeValue(Vertex vertex, String key, VertexProperty property) {
        this.computeProperties.computeIfPresent((Element)vertex, (k, v) -> {
            v.computeIfPresent(key, (k1, v1) -> {
                v1.remove(property);
                return v1;
            });
            return v;
        });
    }

    private List<VertexProperty<?>> getValue(Vertex vertex, String key) {
        return this.computeProperties.getOrDefault(vertex, Collections.emptyMap()).getOrDefault(key, Collections.emptyList());
    }
}

