/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.AbstractIoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TinkerPopJacksonModule;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoWriter;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

public final class TinkerIoRegistryV2d0
extends AbstractIoRegistry {
    private static final TinkerIoRegistryV2d0 INSTANCE = new TinkerIoRegistryV2d0();

    private TinkerIoRegistryV2d0() {
        this.register(GryoIo.class, TinkerGraph.class, (Object)new TinkerGraphGryoSerializer());
        this.register(GraphSONIo.class, null, (Object)new TinkerModuleV2d0());
    }

    @Deprecated
    public static TinkerIoRegistryV2d0 getInstance() {
        return INSTANCE;
    }

    public static TinkerIoRegistryV2d0 instance() {
        return INSTANCE;
    }

    static class TinkerGraphJacksonDeserializer
    extends StdDeserializer<TinkerGraph> {
        public TinkerGraphJacksonDeserializer() {
            super(TinkerGraph.class);
        }

        public TinkerGraph deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            BaseConfiguration conf = new BaseConfiguration();
            conf.setProperty("gremlin.tinkergraph.defaultVertexPropertyCardinality", (Object)"list");
            TinkerGraph graph = TinkerGraph.open((Configuration)conf);
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("vertices")) {
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        if (jsonParser.currentToken() != JsonToken.START_OBJECT) continue;
                        DetachedVertex v = (DetachedVertex)deserializationContext.readValue(jsonParser, Vertex.class);
                        v.attach(Attachable.Method.getOrCreate((Host)graph));
                    }
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("edges")) continue;
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    if (jsonParser.currentToken() != JsonToken.START_OBJECT) continue;
                    DetachedEdge e = (DetachedEdge)deserializationContext.readValue(jsonParser, Edge.class);
                    e.attach(Attachable.Method.getOrCreate((Host)graph));
                }
            }
            return graph;
        }

        public boolean isCachable() {
            return true;
        }
    }

    static final class TinkerGraphJacksonSerializer
    extends StdScalarSerializer<TinkerGraph> {
        public TinkerGraphJacksonSerializer() {
            super(TinkerGraph.class);
        }

        public void serialize(TinkerGraph graph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("vertices");
            jsonGenerator.writeStartArray();
            Iterator<Vertex> vertices = graph.vertices(new Object[0]);
            while (vertices.hasNext()) {
                serializerProvider.defaultSerializeValue((Object)vertices.next(), jsonGenerator);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeFieldName("edges");
            jsonGenerator.writeStartArray();
            Iterator<Edge> edges = graph.edges(new Object[0]);
            while (edges.hasNext()) {
                serializerProvider.defaultSerializeValue((Object)edges.next(), jsonGenerator);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }
    }

    static final class TinkerModuleV2d0
    extends TinkerPopJacksonModule {
        public TinkerModuleV2d0() {
            super("tinkergraph-2.0");
            this.addSerializer(TinkerGraph.class, (JsonSerializer)new TinkerGraphJacksonSerializer());
            this.addDeserializer(TinkerGraph.class, (JsonDeserializer)new TinkerGraphJacksonDeserializer());
        }

        public Map<Class, String> getTypeDefinitions() {
            return new HashMap<Class, String>(){
                {
                    this.put(TinkerGraph.class, "graph");
                }
            };
        }

        public String getTypeNamespace() {
            return "tinker";
        }
    }

    static final class TinkerGraphGryoSerializer
    extends Serializer<TinkerGraph> {
        TinkerGraphGryoSerializer() {
        }

        public void write(Kryo kryo, Output output, TinkerGraph graph) {
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                GryoWriter.build().mapper(() -> kryo).create().writeGraph((OutputStream)stream, (Graph)graph);
                byte[] bytes = stream.toByteArray();
                output.writeInt(bytes.length);
                output.write(bytes);
            }
            catch (Exception io) {
                throw new RuntimeException(io);
            }
        }

        public TinkerGraph read(Kryo kryo, Input input, Class<TinkerGraph> tinkerGraphClass) {
            BaseConfiguration conf = new BaseConfiguration();
            conf.setProperty("gremlin.tinkergraph.defaultVertexPropertyCardinality", (Object)"list");
            TinkerGraph graph = TinkerGraph.open((Configuration)conf);
            int len = input.readInt();
            byte[] bytes = input.readBytes(len);
            try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
                GryoReader.build().mapper(() -> kryo).create().readGraph((InputStream)stream, (Graph)graph);
            }
            catch (Exception io) {
                throw new RuntimeException(io);
            }
            return graph;
        }
    }
}

