/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.util.ExceptionUtils;

public class AprLifecycleListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog(AprLifecycleListener.class);
    private static boolean instanceCreated = false;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected static final int TCN_REQUIRED_MAJOR = 1;
    protected static final int TCN_REQUIRED_MINOR = 1;
    protected static final int TCN_REQUIRED_PATCH = 17;
    protected static final int TCN_RECOMMENDED_PV = 22;
    protected static String SSLEngine = "on";
    protected static String FIPSMode = "off";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean aprInitialized = false;
    protected static boolean sslAvailable = false;
    protected static boolean aprAvailable = false;
    protected static boolean fipsModeActive = false;
    protected static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAprAvailable() {
        if (instanceCreated) {
            Object object = lock;
            synchronized (object) {
                AprLifecycleListener.init();
            }
        }
        return aprAvailable;
    }

    public AprLifecycleListener() {
        instanceCreated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lifecycleEvent(LifecycleEvent event) {
        if ("init".equals(event.getType())) {
            Object object = lock;
            synchronized (object) {
                AprLifecycleListener.init();
                if (aprAvailable) {
                    try {
                        AprLifecycleListener.initializeSSL();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable((Throwable)t);
                        log.error((Object)sm.getString("aprListener.sslInit"), t);
                    }
                }
                if ("on".equalsIgnoreCase(FIPSMode) && !this.isFIPSModeActive()) {
                    Error e = new Error(sm.getString("aprListener.initializeFIPSFailed"));
                    log.fatal((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
        if ("after_stop".equals(event.getType())) {
            Object object = lock;
            synchronized (object) {
                if (!aprAvailable) {
                    return;
                }
                try {
                    AprLifecycleListener.terminateAPR();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    if (!log.isDebugEnabled()) {
                        log.info((Object)sm.getString("aprListener.aprDestroy"));
                    }
                    log.debug((Object)sm.getString("aprListener.aprDestroy"), t);
                }
            }
        }
    }

    private static void terminateAPR() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String methodName = "terminate";
        Method method = Class.forName("org.apache.tomcat.jni.Library").getMethod(methodName, null);
        method.invoke(null, (Object[])null);
        aprAvailable = false;
        aprInitialized = false;
        sslInitialized = false;
        sslAvailable = false;
        fipsModeActive = false;
    }

    private static void init() {
        int major = 0;
        int minor = 0;
        int patch = 0;
        int apver = 0;
        int rqver = 1117;
        int rcver = 1122;
        if (aprInitialized) {
            return;
        }
        aprInitialized = true;
        try {
            String methodName = "initialize";
            Class[] paramTypes = new Class[]{String.class};
            Object[] paramValues = new Object[]{null};
            Class<?> clazz = Class.forName("org.apache.tomcat.jni.Library");
            Method method = clazz.getMethod(methodName, paramTypes);
            method.invoke(null, paramValues);
            major = clazz.getField("TCN_MAJOR_VERSION").getInt(null);
            minor = clazz.getField("TCN_MINOR_VERSION").getInt(null);
            patch = clazz.getField("TCN_PATCH_VERSION").getInt(null);
            apver = major * 1000 + minor * 100 + patch;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            if (!log.isDebugEnabled()) {
                log.info((Object)sm.getString("aprListener.aprInit", System.getProperty("java.library.path")));
            } else {
                log.debug((Object)sm.getString("aprListener.aprInit", System.getProperty("java.library.path")), t);
            }
            return;
        }
        if (apver < rqver) {
            log.error((Object)sm.getString("aprListener.tcnInvalid", major + "." + minor + "." + patch, "1.1.17"));
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
            }
            return;
        }
        if (apver < rcver) {
            if (!log.isDebugEnabled()) {
                log.info((Object)sm.getString("aprListener.tcnVersion", major + "." + minor + "." + patch, "1.1.22"));
            } else {
                log.debug((Object)sm.getString("aprListener.tcnVersion", major + "." + minor + "." + patch, "1.1.22"));
            }
        }
        if (!log.isDebugEnabled()) {
            log.info((Object)sm.getString("aprListener.tcnValid", major + "." + minor + "." + patch, Library.APR_MAJOR_VERSION + "." + Library.APR_MINOR_VERSION + "." + Library.APR_PATCH_VERSION));
        } else {
            log.debug((Object)sm.getString("aprListener.tcnValid", major + "." + minor + "." + patch));
        }
        log.info((Object)sm.getString("aprListener.flags", Library.APR_HAVE_IPV6, Library.APR_HAS_SENDFILE, Library.APR_HAS_SO_ACCEPTFILTER, Library.APR_HAS_RANDOM));
        aprAvailable = true;
    }

    private static void initializeSSL() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        sslInitialized = true;
        String methodName = "randSet";
        Class[] paramTypes = new Class[]{String.class};
        Object[] paramValues = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("org.apache.tomcat.jni.SSL");
        Method method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        methodName = "initialize";
        paramValues[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        if ("on".equalsIgnoreCase(FIPSMode)) {
            log.info((Object)sm.getString("aprListener.initializingFIPS"));
            int result = SSL.fipsModeSet((int)1);
            if (1 == result) {
                fipsModeActive = true;
                log.info((Object)sm.getString("aprListener.initializeFIPSSuccess"));
            } else {
                String message = sm.getString("aprListener.initializeFIPSFailed");
                log.error((Object)message);
                throw new IllegalStateException(message);
            }
        }
        log.info((Object)sm.getString("aprListener.initializedOpenSSL", SSL.versionString()));
        sslAvailable = true;
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String SSLEngine) {
        if (!SSLEngine.equals(AprLifecycleListener.SSLEngine)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLEngine"));
            }
            AprLifecycleListener.SSLEngine = SSLEngine;
        }
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        if (!SSLRandomSeed.equals(AprLifecycleListener.SSLRandomSeed)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLRandomSeed"));
            }
            AprLifecycleListener.SSLRandomSeed = SSLRandomSeed;
        }
    }

    public String getFIPSMode() {
        return FIPSMode;
    }

    public void setFIPSMode(String FIPSMode) {
        if (!FIPSMode.equals(AprLifecycleListener.FIPSMode)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForFIPSMode"));
            }
            AprLifecycleListener.FIPSMode = FIPSMode;
        }
    }

    public boolean isFIPSModeActive() {
        return fipsModeActive;
    }
}

