/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometFilter;
import org.apache.catalina.CometFilterChain;
import org.apache.catalina.filters.FilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class FailedRequestFilter
extends FilterBase
implements CometFilter {
    private static final Log log = LogFactory.getLog(FailedRequestFilter.class);

    protected Log getLogger() {
        return log;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isGoodRequest(request)) {
            ((HttpServletResponse)response).sendError(400);
            return;
        }
        chain.doFilter(request, response);
    }

    public void doFilterEvent(CometEvent event, CometFilterChain chain) throws IOException, ServletException {
        if (event.getEventType() == CometEvent.EventType.BEGIN && !this.isGoodRequest((ServletRequest)event.getHttpServletRequest())) {
            event.getHttpServletResponse().sendError(400);
            event.close();
            return;
        }
        chain.doFilterEvent(event);
    }

    private boolean isGoodRequest(ServletRequest request) {
        request.getParameter("none");
        return request.getAttribute("org.apache.catalina.parameter_parse_failed") == null;
    }

    protected boolean isConfigProblemFatal() {
        return true;
    }
}

