/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

class ByteBufferUtilsUnsafe {
    private static final StringManager sm = StringManager.getManager(ByteBufferUtilsUnsafe.class);
    private static final Log log = LogFactory.getLog(ByteBufferUtilsUnsafe.class);
    private static final Object unsafe;
    private static final Method invokeCleanerMethod;

    private ByteBufferUtilsUnsafe() {
    }

    static void cleanDirectBuffer(ByteBuffer buf) {
        block3: {
            if (invokeCleanerMethod != null) {
                try {
                    invokeCleanerMethod.invoke(unsafe, buf);
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug(sm.getString("byteBufferUtils.cleaner"), e);
                }
            }
        }
    }

    static {
        ByteBuffer tempBuffer = ByteBuffer.allocateDirect(0);
        Object unsafeLocal = null;
        Method invokeCleanerMethodLocal = null;
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = clazz.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafeLocal = theUnsafe.get(null);
            invokeCleanerMethodLocal = clazz.getMethod("invokeCleaner", ByteBuffer.class);
            invokeCleanerMethodLocal.invoke(unsafeLocal, tempBuffer);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.warn(sm.getString("byteBufferUtils.cleaner"), e);
            unsafeLocal = null;
            invokeCleanerMethodLocal = null;
        }
        unsafe = unsafeLocal;
        invokeCleanerMethod = invokeCleanerMethodLocal;
    }
}

