/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum EESpecProfile {
    TOMCAT("javax", "jakarta", "javax([/\\.](annotation(?![/\\.]processing)|ejb|el|mail|persistence|security[/\\.]auth[/\\.]message|servlet|transaction(?![/\\.]xa)|websocket))"),
    EE("javax", "jakarta", "javax([/\\.](activation|annotation(?![/\\.]processing)|batch|decorator|ejb|el|enterprise|faces|jms|json|jws|interceptor|inject|mail|management[/\\.]j2ee|persistence|resource|security[/\\.](auth[/\\.]message|enterprise|jacc)|servlet|transaction(?![/\\.]xa)|validation|websocket|ws[/\\.]rs|xml[/\\.](bind|soap|ws)))"),
    JEE8("jakarta", "javax", "jakarta([/\\.](activation|annotation(?![/\\.]processing)|batch|decorator|ejb|el|enterprise|faces|jms|json|jws|interceptor|inject|mail|management[/\\.]j2ee|persistence|resource|security[/\\.](auth[/\\.]message|enterprise|jacc)|servlet|transaction(?![/\\.]xa)|validation|websocket|ws[/\\.]rs|xml[/\\.](bind|soap|ws)))");

    private String source;
    private String target;
    private Pattern pattern;

    private EESpecProfile(String source, String target, String pattern) {
        this.source = source;
        this.target = target;
        this.pattern = Pattern.compile(pattern);
    }

    public String convert(String name) {
        Matcher m = this.pattern.matcher(name);
        return m.replaceAll(this.target + "$1");
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }
}

